<?php
/*
 * GGFauthenticate.php
 *
 * Web-Server-Based HTTP Authentication
 * ------------------------------------
 * 
 * This is a sample for a web server based HTTP authentication handling. 
 * - It has the advantage that every file of your public web server directory
 * is protected .JPG, .TXT etc - not only PHP files.
 * You do not need to create a login dialog. It is provided by your web browser.
 * To implement this you have to configure your web server accordingly. 
 * - The disadvantage is, that users cannot logoff. They have to close their
 * web browser to finish their login.
 *
 * You need to tell your server which directories are to be protected. Here it is shown
 * how this is done for the Apache web server. You can specify the protected location
 * either in the httpd.conf file in the server's conf directory (in a "Directory" section)
 * or in a .htaccess file directly in the directory that should be protected. The second
 * approach works only, if the server's configuration allows it. You need
 * 
 *    AllowOverride AuthConfig 
 * 
 * in Apache's httpd.conf file. 
 * 
 * Furthermore an "auth_digest_module" and an authentication provider like 
 * "authn_file_module" module must be loeded. You need 
 * 
 *    LoadModule auth_digest_module modules/mod_auth_digest.so
 *    LoadModule authn_file_module modules/mod_authn_file.so
 *    
 * in the Apache conf file.
 * More about this here://httpd.apache.org/docs/2.4/howto/auth.html
 * However your web service provider must allow to configure your system
 * like this. That is not always the case. In that case refer to 
 * PHP-initiated HTTP Authentication 
 * 
 * In the .htaccess file you need to specify the following: 
 * 
 * Authentication Type : specifies how client and server communicate in the 
 * authentication process. Use digest authentication, because it transfers
 * passwords encrypted.
 * 
 * Authentication Name: a text (authorization realm) that tells the user, where 
 * he logs in (usually the name of the system and server). This is displayed by 
 * the browser in the login dialog. It is also used in the password file 
 * (see below). It must *not* contain a colon. See variable $realm below.
 * 
 * AuthDigestDomain : URL to your application.
 * 
 * Authentication Provider : specifies how the user id and the password are 
 * checked by the server. This can be done using a password file on the server, 
 * by accessing an SQL database or accessing an LDAP interface (Note: the 
 * windows authentication provider ISSP is not available for Apache 2.4 anymore)
 * 
 * For checking user-id / password against a file, enter the following into your .htaccess file
 * 
 *   AuthType Digest
 *   AuthName "Application Myapp"
 *   AuthDigestDomain http:/localhost/ggf/
 *   AuthDigestProvider file
 *   AuthUserFile e:/programme/xampp18/htdocs/ggf/GGF/GGFuser.txt
 *   Require valid-user
 * 
 * The file e:/programme/xampp18/htdocs/ggf/GGF/GGFuser.txt is stored somewhere 
 * on the server. The documentation says the path is relative to the server root 
 * (which may be something like E:\Programme\xampp\apache ; but I found it works 
 * with an absolute path )
 * It contains the list of valid users and their (encrypted) passwords.
 * Therefore it must not be stored in a directory that is accessible by clients.
 * 
 * Create the file GGFUser.txt with Apache's htpasswd tool.
 * If you want to allow access for the user 'test' and the user 'demo' 
 * to application "Myapp", enter the following on the command line prompt: 
 * 
 * \programme\xampp\apache\bin\htdigest -c GGFUser.txt "Application Myapp" demo
 * \programme\xampp\apache\bin\htdigest    GGFUser.txt "Application Myapp" test
 * 
 * Note: Use htdigest and not the htpasswd tool. The tool will prompt for the 
 * passwords. Be sure that the first parameter, the realm is the same like the
 * authname in the htaccess file.
 * 
 * The generated file GGFUser.txt contains the following (if
 * the passwords were the same as the user id's)
 * 
 * test:Application Myapp:067f4c29e2de31b0c375ca622fcb67c7
 * demo:Application Myapp:7f7864defe964bdc1111d4a42edfd0ae
 * 
 * Copy the generated file to /MyApp/GGF/GGFUser.txt .
 * 
 * 
 */
global $appname;
$realm = 'Application '.$appname; // must be the same like the authname in the .htaccess file

if (!isset($_SESSION["userid"]) || ($_SESSION["userid"]=="")) {
	// routine was not yet executed, we don't know yet who the user is
	if (!isset($_SERVER["REMOTE_USER"])) { // the web browser also does not know it
		//$_SESSION["loginrequested"]==TRUE;
		header('HTTP/1.1 401 Unauthorized');
		// this causes the browser to display a login-dialog and retry the request
		header('WWW-Authenticate: Digest realm="' . $realm .
           '",qop="auth",nonce="' . uniqid() . '",opaque="' . md5($realm) .
           '"');
		echo $realm." needs a valid login.";
		exit;
	} else { // web browser has asked for Userid and password has submitted 
		// them to the server and got an OK
		
		$_SESSION['userid'] = $_SERVER['REMOTE_USER'];  
		// $_SESSION['userid'] will used by the framework to check if a user is logged on
	}
} 

?>