<?PHP
/**
 * Implementation of SQL filter class
 *
 * note: this class is not deprecated, because it is used internally. 
 * use GGFERFilter in in all normal cases -  except for instancevariables of GGFEntityType (joinfilter)
 * 
 * @todo comment, test
 * @package GGF
 * @version 4.0
 * @since 2.3
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2012 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFSqlFilter extends GGFSqlFilterClause {
	// GGF (c) 2005 - Gerald Zincke, Austria
	
	/*
	example creating a complex filter:
		$f = new GGFSqlFilter();
   		$f->add(new GGFSqlFilterClause("AND","firstname","<>","'Administrator'"));
   		$f->add(new GGFSqlFilterClause("OR","userid","=","'admin'"));
   		$f2 = new GGFSqlFilter('OR');
   		$f2->add(new GGFSqlFilterClause("AND","firstname","=","'Administrator'"));
   		$f2->add(new GGFSqlFilterClause("AND","userid","LIKE","'ad%'"));
   		$f->add($f2);
   	generates SQL with $f->whereClause():
   		WHERE (firstname <> 'Administrator' OR userid = 'admin' OR 
   		      (firstname = 'Administrator' AND userid LIKE 'ad%'))
   	*/	
	
	protected $clauses = array();
	
	function __construct($andor='AND') {
		$this->clauseOperator = $andor;
	}
	
	function __clone()
	{
        	$nca = array();
        	foreach($this->clauses as $cl) {
	        	array_push($nca,clone($cl));
	        }
	        $this->clauses = $nca;	
 	}
 	
 	//GGF3.2.1
	public function setClauseOperator($andor) {
		$this->clauseOperator = $andor;
	}
	public function setWhereClause($sql) {
		// removed interface
		error_log_adv (__CLASS__.":".__FUNCTION__.": removed");
	}
	
	public function setCriteria($crit) {
		// removed interface
		error_log_adv (__CLASS__.":".__FUNCTION__.": removed");
	}
	
	public function getCriteria() {
		// removed interface
		error_log_adv (__CLASS__.":".__FUNCTION__.": removed");
	}
	
	public function add($aClause) {
		// add a GGFSqlFilterClause
		array_push($this->clauses,$aClause);
	}
	
	public function remove($anIndex) {
		// remove a GGFSqlFilterClause
		unset($this->clauses[$anIndex]);
		$a = array();
		foreach($this->clauses as $cl) {
			array_push($a,$cl);
		}
		$this->clauses = $a;
	}
	
	public function clear() {
		$this->clauses = array();
	}

	
	public function clauses() {
		return $this->clauses;
	}
	public function setClauses($ar) {
		$this->clauses = $ar;
	}
	
	public function matches($aRow) {
		$res = TRUE;
		foreach($this->clauses as $clause) {
			if ($clause->clauseOperator() == 'AND') {
				$res = $res && $clause->matches($aRow);
			} else {
				$res = $res || $clause->matches($aRow);
			}
			if ($res == FALSE) {
				break;
			}
		}
		return $res;
	}
	
	public function asSQL() {
		// note this does not return the Keyword WHERE
		$res = "(";
		foreach ($this->clauses as $clause) {
			if ($res == "(") {
				$res = $res . $clause->asSQL();
			} else {
				$res = $res . " ". $clause->clauseOperator() . " " . $clause->asSQL();
			} 
			//error_log_adv(print_r($clause,TRUE));
		}
		// error_log_adv("filter:".$res);
		return $res.")";
	}
	
	public function whereClause() {
		$sql = $this->asSQL();
		if ( $sql == '()') {
			return '';
		} else {
			return 'WHERE '.$sql;
		}
	}
}
?>