<?PHP 
/**
 * This is the update dialog for the GGFQuery table
 * For GGF internal use.
 * 
 * @package GGF 
 * @version 3.3
 * @since 3.3
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFQueryUpdateDialog extends GGFControlUpdateDialog {
	function __construct($contextID) {
		parent::__construct($contextID);
		$this->ETypeName = "GGFQuery";
	}
	public function dataPlausible() {
		// if true, OK can be clicked
		return $this->isLoggedOn();
	}
	protected function initWindow($mc) {
		GGFControlDialog::initWindow($mc);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Type updates and click OK."));
		$formarea->newLine();
		$formarea->newRow(new GGFStaticfield("", "id"));
		$ef = new GGFEntryfield("id", "",10, 10, $tiptext="(int)"); /* tiptext derived from column_content */
		$ef->setReadonly();
		$formarea->newCell($ef);
		$formarea->newRow(new GGFStaticfield("", "owner"));
		$ef = new GGFEntryfield("owner", "",16, 16, $tiptext="(varchar)"); /* tiptext derived from column_content */
		$ef->setReadonly();
		$formarea->newCell($ef);
		$formarea->newRow(new GGFStaticfield("", "ETypeName"));
		$ef = new GGFEntryfield("ETypeName", "",64, 64, $tiptext="(varchar)"); /* tiptext derived from column_content */
		$ef->setReadonly();
		$formarea->newCell($ef);
		$formarea->newRow(new GGFStaticfield("", "qname"));
		$ef = new GGFEntryfield("qname", "",80, 128, $tiptext="(varchar)"); /* tiptext derived from column_content */
		$formarea->newCell($ef);
		//$formarea->newRow(new GGFStaticfield("", "filter"));
		//$ef = new GGFMultilineEntryfield("filter", "", 80, 5, 65535, $tiptext="(text)"); /* tiptext derived from column_content */
		//$ef->setReadonly();
		//$formarea->newCell($ef);
		//$formarea->newRow(new GGFStaticfield("", "sorter"));
		//$ef = new GGFMultilineEntryfield("sorter", "", 80, 5, 65535, $tiptext="(text)"); /* tiptext derived from column_content */
		//$ef->setReadonly();
		//$formarea->newCell($ef);
		//$formarea->newRow(new GGFStaticfield("", "thecolumns"));
		//$ef = new GGFMultilineEntryfield("thecolumns", "", 80, 5, 65535, $tiptext="(text)"); /* tiptext derived from column_content */
		//$ef->setReadonly();
		//$formarea->newCell($ef);
		$formarea->closeTable();
		$formarea->newLine();
	}
		
}
?>