<?PHP
/**
 * Dialog to edit an ERFilter object
 *
 * assume  model[0] = anERFilter
 * model[1] = selection
 *
 * @package GGF
 * @version 3.2.2
 * @since 3.0
 * @author Gerald Zincke, Austria
 * @copyright 2005 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFERFilterDialog extends GGFControlDialog {

	/** @var GGFStaticfield a control to display error messages */
	protected $bugfield;
	
	function __construct($contextID) {
		$this->bugfield = new GGFStaticfield("bugfield", "xxxx"); // instantiate it here that it can be accessed iven before initWindow
		parent::__construct($contextID);
		//echo("bugfield:".print_r($this->bugfield,TRUE));
		//exit;
	}
	
	protected function initWindow($mc) {
		parent::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Update filter clauses and click OK."));
		$formarea->newLine();
		$formarea->newRow(new GGFRadioGroup("concat", array("AND","OR"), "AND", $hsize=0, $extraHTML = "") );
		$formarea->newCell(new GGFListbox("clauses", array(), array(), 
					$hsize=500, $vsize= 13, 
					$tiptext="List of the filter clauses", 
					$extraHTML = "", TRUE));

		$buttonColumn = new GGFControlPane($this,"buttonColumn");
		$buttonColumn->newRow(new GGFPushbutton("addClause",    "Add Clause",    "eventAddClause",    $validator="", $size=90, $tiptext="add a new clause to the filter", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("addSubfilter", "Add Subfilter", "eventAddSubfilter", $validator="", $size=90, $tiptext="add a new subfilter (expression in brackets)", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("edit",         "Edit",          "eventEdit",         $validator="", $size=90, $tiptext="edit the selected filter clause or subfilter", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("up",           "^",             "eventUp",           $validator="", $size=90, $tiptext="move the selected filter clause or subfilter upwards", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("down",         "v",             "eventDown",         $validator="", $size=90, $tiptext="move the selected filter clause or subfilter down", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("del",          "Remove",        "eventRemove",       $validator="", $size=90, $tiptext="remove the selected filter clause or subfilter", $extraHTML=""));
		$buttonColumn->newRow(new GGFPushbutton("clear",          "Rem.All",        "eventClear",       $validator="", $size=90, $tiptext="remove all filter clauses or subfilter", $extraHTML=""));
		$buttonColumn->closeTable();
		$formarea->newCell($buttonColumn);
		$formarea->closeTable();
		$formarea->newLine();
		
		$buttonarea = $this->pane->named("_buttonarea");
		$buttonarea->newSpace(2);
		$buttonarea->add(new GGFPushbutton("SQL", "Show SQL", "eventShowSQL", "", 80, "display the filter as SQL string"));
		$buttonarea->newLine();
		$buttonarea->add($this->bugfield); //note this has to be after the OK button, because it is set by its validator
	}
	
	protected function readControls($mc) {
		parent::readControls($mc);
		
		$co = $this->pane->named("concat")->getSelection();
		$this->myModel[0]->setClauseOperator($co);
		
		$sel = $this->pane->named("clauses")->getSelection();
		$this->myModel["_selection"] = $sel[0];
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	protected function fillControls($mc) {
		
		$this->windowTitle = $this->myModel[0]->type()->name()." - filter";
		
		$co = $this->myModel[0]->clauseOperator();
		$this->pane->named("concat")->setSelection($co);
		
		$cl = $this->myModel[0]->clauses();
		$clSQL = array();
		foreach ($cl as $clause) {
			array_push($clSQL,$clause->clauseOperator().' '.$clause->asSQL());
		}
		
		if (isset($this->myModel[1][1])) {
			$selections = array($this->myModel[1][1]);				
		} else {
			$selections = array($clSQL[0]);
		}
		$this->pane->named("clauses")->setSelection($selections);
		$this->pane->named("clauses")->setValue($clSQL);
		//$this->dataPlausible();
		parent::fillControls($mc);		
	}

	

	//---callbacks--------------------------
	
	/**
	 * create a filterclause and open a dialog on it
	 *
	 */
 	protected function eventAddClause() {
		$clause = new GGFSqlFilterClause("AND", $this->myModel[1][1], "=", "");
		$mc = &windowContext($this->myContextID,0);
 				
		$mc->model = $this->myModel;
		$mc->save();
		// prepare the model for the update dialog 
		// model[0] = aFilterClause
		// model[1] = filter
		// (add will supply a default-filterclause on column[1] = defaultvalue[1])
		$mod = array($clause,$filter = $this->myModel[0]);
		$mc->openDialogOn("GGFERFilterClauseDialog",$mod , $cont="eventAddClauseReturn"  );
		exit;
	}

	protected function eventAddClauseReturn($subContextID) {
		// process selected level
		global $errorStack;
   		$subContext = &windowContext($subContextID,0);

   		if ($subContext->result) { // OK, clause saved
   			//print_r($subContext->model[0]);
   			//print_r($subContext->model[0]->asSQL());
   			
   			//exit;
   			
   			$this->myModel[0]->add($subContext->model[0]); // add the new clause
	   	}
	}

	/**
	 * create a subfilter and open this dialog recursively
	 *
	 */
 	protected function eventAddSubfilter() {
		// create a sub filter and open a dialog on it
		
		$filter = new GGFERFilter($this->myModel[0]->type(),"AND");
		$mc = &windowContext($this->myContextID,0);		
		$mc->model = $this->myModel;
		$mc->save();
		// prepare the model for the update dialog 
		// assume  model[0] = aFilter
		// model[1] = selection
	
		$mod = array($filter, array() );
		$mc->openDialogOn("GGFERFilterDialog",$mod , $cont="eventAddSubfilterReturn"  );
		exit;
	}

	protected function eventAddSubfilterReturn($subContextID) {
		// process selected level
		global $errorStack;
   		$subContext = &windowContext($subContextID,0);

   		if ($subContext->result) { // OK, clause saved
   			$this->myModel[0]->add($subContext->model[0]); // add the new clause=subfilter
	   	}
	}
	
	/**
	 * clone the selected filterclause and open a dialog on it
	 *
	 */
 	protected function eventEdit() {
		$mc = &windowContext($this->myContextID,0);		
		//$this->readControls($mc);
		
		$cls = $this->myModel[0]->clauses();
		if ($this->myModel["_selection"] != array()) {
			$clause = $cls[$this->myModel["_selection"]];
		
			if ($clause instanceof GGFERFilter) {
				// prepare the model for the update dialog 
				// assume  model[0] = aFilter
				// model[1] = selection
	
				$mod = array(clone($clause), array()  );
				$mc->openDialogOn("GGFERFilterDialog",$mod , $cont="eventEditReturn"  );		
			} else { //clause
				// prepare the model for the update dialog 
				// model[0] = aFilterClause
				// model[1] = filter
				// (add will supply a default-filterclause on column[1] = defaultvalue[1])
				$mod = array(clone($clause), $this->myModel[0]);
				$mc->openDialogOn("GGFERFilterClauseDialog",$mod , $cont="eventEditReturn"  );
			}
			exit;
		}
	}

	protected function eventEditReturn($subContextID) {
		$subContext = &windowContext($subContextID,0);

   		if ($subContext->result) { // OK, modifications saved
   			$cls = $this->myModel[0]->clauses();
			$cls[$this->myModel["_selection"]] = $subContext->model[0];
			$this->myModel[0]->setClauses($cls);
	   	}
	}

	protected function eventUp() {
		// determine the clause to be moved
		$mc = &windowContext($this->myContextID,0);		
		//$this->readControls($mc);
		if ($this->myModel["_selection"] != array()) {
		
		   if ($this->myModel["_selection"] > 0) {	// not already on top	
			$oldset = $this->myModel[0]->clauses();
			$selitem = $oldset[$this->myModel["_selection"]];
			$newset = array();
			$newset[0] = $oldset[0];
			for ($i=1; $i < count($oldset); $i++) {
				if ($selitem == $oldset[$i]) {
					$save = $newset[($i - 1)];
					$newset[($i-1)] = $oldset[$i];
					//error_log_adv("upped ".$oldset[$i]." at ".($i-1));
					$newset[$i] = $save;
					//error_log_adv("down ".$save." at ".$i);

				} else {
					//error_log_adv("put ".$oldset[$i]." at ".$i);
					$newset[$i] = $oldset[$i];
				}
			}
			$this->myModel[0]->setClauses($newset);
			$mc->model = $this->myModel;
			$mc->save();
		   }
		}
	}
	
	protected function eventDown() {
		// determine the clause to be moved
		$oldset = $this->myModel[0]->clauses();
		$mc = &windowContext($this->myContextID,0);		
		//$this->readControls($mc);
		if ($this->myModel["_selection"] != array()) {
		   if ($this->myModel["_selection"] < (count($oldset) - 1)) {	// not already on bottom	
			$newset = array();
			$nr = count($oldset) - 1;
			$selitem = $oldset[$this->myModel["_selection"]];
			for ($i=0; $i <= ($nr - 1)  ; $i++) {
				if ($selitem == $oldset[$i]) {
					// oldset[$i] gehrt einen spter
					$newset[$i] = $oldset[($i + 1)];
					$oldset[($i + 1)] = $oldset[$i];
					$selitem = "++++++++"; // suppress furthe rmoves
				} else {
					//error_log_adv("put ".$oldset[$i]." at ".$i);
					$newset[$i] = $oldset[$i];
				}
			}
			$newset[$nr] = $oldset[$nr];
			$this->myModel[0]->setClauses($newset);
			$mc->model = $this->myModel;
			$mc->save();
		   }
		}
	}


	protected function eventRemove() {
		// determine the selected clause
		
		if ($this->myModel["_selection"] != array()) {
			// ask user if he really wants to delete the clause
			$cls = $this->myModel[0]->clauses();
			//print_r($cls);
			$cl = $cls[$this->myModel["_selection"]];
			//echo(print_r($cls,TRUE).':'.$this->myModel["_selection"].":".print_r($cl,TRUE));
			messageBox($this->myContextID,
			"Are you sure that you want to delete clause:".$cl->asSQL()." ?",
			2,
			"eventRemoveReturn");
			// results of dialog will be processed in eventDeleteReturn
			exit;
		}
	}

	protected function eventRemoveReturn($subContextID) {
		// remove the clause from the list
		
		$subContext = &windowContext($subContextID,0);
   		if ($subContext->result) {
   			// do the delete action
   			$this->myModel[0]->remove($this->myModel["_selection"]);
	   	}
	}

	protected function eventClear() {
		messageBox($this->myContextID,
			"Are you sure that you want to clear the whole filter ?",
			2,
			"eventClearReturn");
		exit;
	}

	protected function eventClearReturn($subContextID) {
		$subContext = &windowContext($subContextID,0);
   		if ($subContext->result) {
   			$this->myModel[0]->clear();
	   	}
	}

	protected function eventShowSQL() {
		messageBox($this->myContextID,
			"Filter in SQL:
".$this->myModel[0]->asSQL(),
			1,
			"");
		exit;
	}

	public function dataPlausible() {
		// if true, OK can be clicked
		global $db;
		global $errorStack;
		global $traceLevel;
		//error_log_adv("dataPlausible called");
		// try do read from the database

		$f = $this->myModel[0];
		$count = $f->count();
		
		if ($count < 0) {
			// in this case do not process the usual error-handling
			$msga = $errorStack->popAll();
			$msgs = "";
			foreach ($msga as $msg) {
				$msgs = $msgs.$msg;
			}
			$this->bugfield->setValue($msgs);
			return FALSE;
		} else {
			$this->myModel["_list"] = array();		
			$this->bugfield->setValue("Selects ".$count." rows.");
			return TRUE;
		}
	}	

	protected function eventOK() {
		$this->ok = TRUE;
		$this->eventClose();	
	}
	
	//---open---------------
   		
	protected function initModel($mc) {
		// abstract, may be needed for windows, updating a model data structure
   		// prepare the model object
   		$this->myModel = $mc->model;
	}
	
	protected function openFormContents() {
		echo $this->pane->render();
	}

}
?>