<?PHP
/**
 * Dialog to edit a simple ERfilterClause
 * For GGF internal use.
 * 
 * assume model[0] = a GGFERFilterClause
 * model[1] = an ERFilter
 * 
 * @todo 
 * @package GGF
 * @version 4.0
 * @since 3.0
 * @author Gerald Zincke, Austria
 * @copyright 2005-2012 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFERFilterClauseDialog extends  GGFControlDialog {
	
	protected function initModel($mc) {
		// abstract, may be needed for windows, updating a model data structure
   		// prepare the model object
   		// debug_print_backtrace();
   		parent::initModel($mc);
   		if (!isset($this->myModel["_page"])) {
	   		$this->myModel["_page"] = 1;
	   		$mc->model = $this->myModel;
			$mc->save();
   		}	
	}

	protected function initWindow($mc) {
		parent::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Specify filter clause and click OK."));
		$formarea->newLine();
		$formarea->newRow(new GGFStaticfield("", "concat"));
		$formarea->newCell(new GGFStaticfield("", "column"));
		$formarea->newCell(new GGFStaticfield("", "operator"));
		$formarea->newCell(new GGFStaticfield("", "value"));
		$formarea->newRow(new GGFRadioGroup("andor", array("AND","OR"), "AND", $hsize=0, $extraHTML = "") );
		
		//GGF3.1.2
		$formarea->newCell(new GGFListbox("columns", array(), array(),
						  $hsize=450, $vsize= 15, $tiptext="select a column", 
						  $extraHTML = "") );
		$formarea->newCell(new GGFListbox("operators", array("=","<",">",">=","<=","<>","LIKE","NOT LIKE","IS NULL", "NOT NULL"), 
							array("="), 
						  $hsize=100, $vsize= 10, $tiptext="select a an operator", 
						  $extraHTML = "") );
		$ep = new GGFControlPane($this,"_entryPane");
		$vf = new GGFEntryfield("val", "",    40, $maxlength=255, $tiptext="The value to be compared. Escape % and _ with \. Leave empty for NULL comparisons");
		$vf->setInputClass(1);				  
		$ep->add($vf );
		
		$formarea->newCell($ep);
				
		$formarea->closeTable();
		$formarea->newLine();
		//print_r($this->pane);
		$ep =  $this->pane->named("_entryPane");
		$ep->newRow(new GGFPushbutton("valueselect", "Select...", "eventSelectValue", "", 0, "allows to select a value from a list"));
	}
		
	protected function readControls($mc) {
	
		$andor = $this->pane->named("andor")->getSelection();
		$fi =    $this->pane->named("columns")->getSelection();
		$op =    $this->pane->named("operators")->getSelection();
		$val =   $this->pane->named("val")->value();
	
		$f = $this->myModel[1];
		$et = $f->type();
		//print_r($fi);
		$att = $et->getAttributeNamed($fi[0]);

		if ($att instanceof GGFTextAttribute) {
			$this->myModel[0] = new GGFSqlFilterClause($andor, $fi[0], $op[0], $val, 1);
		} else {
			$this->myModel[0] = new GGFSqlFilterClause($andor, $fi[0], $op[0], $val, 0);
		}
		
		$mc->model = $this->myModel;
		$mc->save();
		
	}
	
	protected function fillControls($mc) {

		$selections = $this->myModel[0]->clauseOperator();
		$this->pane->named("andor")->setSelection($selections);

		$f = $mc->model[1];
		$an = $f->type()->attributeNames();

		$selections = array($this->myModel[0]->field());		
		$this->pane->named("columns")->setSelection($selections);

		//$this->pane->named("columns")->setValue($an);
		$cs = $an;
		//GGF3.2.2
		natcasesort($cs);
		$this->pane->named("columns")->setValue($cs);
		// error_log_adv(print_r($this->pane->named("columns"),TRUE));
		
		$selections = array($this->myModel[0]->comparisonOperator());		
		$this->pane->named("operators")->setSelection($selections);
		
		$this->pane->named("val")->setValue($this->myModel[0]->value());
	
	}
	
	//---callbacks--------------------------
	
	protected function eventSelectValue() {
		// open a lookupdialog to select value from array
		global $db;
		global $errorStack;
		global $largeListThreshold;
		
		$mc = &windowContext($this->myContextID,0);
		$preselection = array($this->pane->named("val")->value());
		
		$field = $this->pane->named("columns")->getSelection();
		if (count($field) <= 0) {
			return;
		}
		if ($field[0] == "") {
			return;
		}
		
		$f = $mc->model[1];
		$et = $f->type();
		
		$sorter = new GGFSqlSorter();
		$sorter->setCriteria($field);
		
		$sel = $et->createSelect($field,
			$filter=new GGFERFilter($et),
			$sorter, $page = $this->myModel["_page"], $pageSize = $largeListThreshold,  $distinct=TRUE, $addPrimaryKey=FALSE);
		
		$res = $db->execSQL($sel);
		if (!$db->OK()) {
			$errorStack->pushMsg("GGFERFilterDialog: Cannot read filter values.");
			// not necessary to display error here, done in open
			return;
		} else {
			
			$options = array();
			if ($this->myModel["_page"] > 1) {
				array_push($options,'---restart---');
			}
			while($row = $db->fetchRow($res)) {
				array_push($options, $row[$field[0]]);
			}
		}
		if (count($options) >= $pageSize) {			
			array_push($options,'---more---');
		}
		//print_r($this->myModel[0]);
		$mc->model = $this->myModel;
		$mc->save();
		
		//GGF3.2.1
		//$psi = array(array_search($preselection[0], $options));  // pre selection indices
		
		// open GGFLookupDialog
		lookupBox($this->myContextID, $options,"eventSelectValueReturn","Select ".$field." value",$preselection);
	}

	protected function eventSelectValueReturn($subContextID) {
		// process selected value
		global $errorStack;
   		$subContext = &windowContext($subContextID,0);
			
   		if ($subContext->result) { // OK, a value was selected
   			
			$mc = &windowContext($this->myContextID,0);
			$val =   $subContext->model[0][0];
			if ($val == "---more---") { // scroll down
				$this->myModel["_page"] = $this->myModel["_page"] + 1;
				$mc->model = $this->myModel;
				$mc->save();
				$this->eventSelectValue();
			}
			if ($val == "---restart---") { // go first page of values
				print_r($val);
				$this->myModel["_page"] = 1;
				$mc->model = $this->myModel;
				$mc->save();
				$this->eventSelectValue();
			}
			//GGF3.2.1			
			$andor = $this->myModel[0]->clauseOperator();
			$fi =    $this->myModel[0]->field();
			$op =    $this->myModel[0]->comparisonOperator();
			
			$f = $this->myModel[1];
			$et = $f->type();
			$att = $et->getAttributeNamed($fi[0]);

			if ($att instanceof GGFTextAttribute) {
				$this->myModel[0] = new GGFSqlFilterClause($andor, $fi, $op, $val, 1);
			} else {
				$this->myModel[0] = new GGFSqlFilterClause($andor, $fi, $op, $val, 0);
			}
	   	}
	}
	
	protected function eventOK() {
		// handles OK event
		if ($this->ok = $this->validateData()) {
			$this->eventClose();
		}
	}
}
	

?>