<?php
/**
 * GGF database class
 *
 * api/transaction-manager for MySQL
 * The name of the db-host, the database, the user and the password are specified 
 * in GGFSetup. It assumes that there is a table user in the database. See GGF.sql .
 * The GGF Framework will open a database connection automatically and a database object
 * is provided in the global variable $db. See GGF.php.
 * 
 * @package GGF
 * @version 3.3
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFDatabase {
	protected $transactionLevel=0;
	protected $taStatus;
	protected $dbhost;
	protected $dbuser;
	protected $dbpw;
	protected $dbname;
	protected $appname;
	protected $execResult;
	protected $lastID;
	protected $dblink;

	function __construct($h, $u, $p, $n, $a) {
		$this->dbhost = $h;
		$this->dbuser = $u;
		$this->dbpw =   $p;
		$this->dbname = $n;
		$this->appname = $a;
		global $errorStack;
   		global $traceLevel;
		$this->taStatus = TRUE;
						
		//     open db
		$lnk = mysql_connect($this->dbhost,$this->dbuser,$this->dbpw);
		$err = mysql_errno();
		if (!$err==0) {
			$this->taStatus = FALSE;	// new transaction is NOK
			$errmsg = $this->appname.": A MYSQL-Error occurred connecting to: ".$this->dbhost.
			" using userID:".$this->dbuser.
			$err." ".mysql_error();
			$errorStack->pushMsg($errmsg);
		} else {
			$this->dblink = $lnk;
			mysql_select_db($this->dbname);
			$err = mysql_errno();
			if (!$err==0) {
				$this->taStatus = FALSE;	// new transaction is NOK
				$errmsg = $this->appname.": A MYSQL-Error occurred selecting: ".$this->dbname.
				$err." ".mysql_error();
				$errorStack->pushMsg($errmsg);
			} else {
				//test user table
				mysql_query('select * from user');
				$err = mysql_errno();
				if (!$err==0) {
					$this->taStatus = FALSE;	// new transaction is NOK
					$errmsg = $this->appname.": A MYSQL-Error occurred reading user table in: ".$this->dbname.
					$err." ".mysql_error();
					$errorStack->pushMsg($errmsg);
				} else {
					return;
				}
			}     	  	
		}
		$errorStack->pushUsrMsg(1,"Cannot access to database.");
   	}
	function __destruct() {
		if (isset($this->dblink)) {
			mysql_close ($this->dblink);
		}
   	}	
   	public function OK() {
   		return $this->taStatus;
   	}
   	
   	public function lastInsertID() {
   		return $this->lastID; 
   	}
   	
   	public function lastErrNo() {
   		return mysql_errno();
   	}
   	
	public function escape_string($string) {
   		return mysql_real_escape_string($string);
   	}
	/**
	 * Execute an SQL statement. Optionally write a protocol into history table.
	 * 
	 * @global type $errorStack
	 * @global type $traceLevel
	 * @global type $historyTable
	 * @param string $sql
	 * @param string $table (optional. provide table name here to write a protocol into history table)
	 * @param string $historyData (optional. provide special history data; per default $sql will be recorded
	 * @return int mysql_query result code
	 */
	public function &execSQL($sql, $table="", $historyData=0) {
   		global $errorStack;
   		global $traceLevel;
   		global $historyTable;
   		
	   	$this->execResult = mysql_query($sql);
		if ($traceLevel>=2) { error_log_adv ("L".$this->transactionLevel.":".$sql);}
		$err = mysql_errno();
		if ($err==0) {
			if ($this->transactionLevel == 0) { // not in transaction
				$this->taStatus = TRUE;
			}

			$this->lastID = mysql_insert_id();
   				
   			if (!$table == "") {
   				// write a log into history table
   				// the history table contains the following fields
   				// id, timestamp, user, table, data 
   				if (isset($_SESSION["userid"])) {
	   				$username = $_SESSION["userid"];
	   			} else {
	   				$username = 'not logged in';
	   			}
	   			if ($historyData == 0) {
	   				$hd = $sql;
	   			} else {
	   				$hd = $historyData;
	   			}

	   			if (isset($_SERVER["REMOTE_ADDR"])) {
	   				$addr = $_SERVER["REMOTE_ADDR"];
	   			} else {
	   				$addr = 'localhost';
	   			}

   				mysql_query("INSERT INTO ".$this->escape_string($historyTable)." VALUES(NULL, NOW(), '".
   					$this->escape_string($username)."','".$this->escape_string($addr)."','".
   					$this->escape_string($table)."','".$this->escape_string($hd)."')");

   			}
			return $this->execResult;
		} else {
			$this->taStatus = FALSE;	// new transaction is NOK
			$errmsg = "$this->appname ".__CLASS__."->".__FUNCTION__.": An SQL-Error occurred: ".
			$err." ".mysql_error()." Statement: ".$sql ;
			$errorStack->pushMsg($errmsg);
	   		return 0;
		}
   	}

   	public function fetchRow($aResult=0) {
   		// this is to encapsulate mysql specifics
   		if ($aResult==0) {
		   	$row = mysql_fetch_assoc($this->execResult);
		} else {
		   	$row = mysql_fetch_assoc($aResult);
		}
		return $row;
   	}
	/**
	 * Begin a database transaction.
	 * This handles nested transactions.
	 * 
	 * @global GGFErrorStack $errorStack
	 * @global integer $traceLevel 
	 */
   	public function beginTransaction() {
   		global $errorStack;
   		global $traceLevel;
   		if ($this->transactionLevel==0) {
	   		$this->taStatus = TRUE;	// new transaction is OK
			if ($traceLevel>=2) { error_log_adv ("$this->appname ".__CLASS__."->".__FUNCTION__.": BEGIN");}
	   		$this->execSQL("BEGIN");

			$err = mysql_errno();
			if (!$err==0) {
		   		$this->taStatus = FALSE;	// new transaction is NOK
				$errmsg = "$this->appname ".__CLASS__."->".__FUNCTION__.": An SQL-Error occurred: ".
				$err." ".mysql_error()." Statement: BEGIN" ;
				$errorStack->pushMsg($errmsg);
			}
	   		
	   	}
	   	$this->transactionLevel++;
   	}
	/**
	 * Use this to cancel a database transaction, if it cannot be finished because of an error.
	 * an SQL Rollback statement will be executed.
	 * 
	 * @global type $errorStack
	 * @global type $traceLevel 
	 */
   	public function cancelTransaction() {
   		global $errorStack;
   		global $traceLevel;
   		if ($this->transactionLevel==0) {
   			// error in transaction-nesting
   			$errorStack->pushMsg('GGF001E Tried to end a transaction when no transaction was open');
   		} else {
	   		$this->transactionLevel--;
   			if ($this->transactionLevel==0) {
   				if ($traceLevel>=2) { error_log_adv ("$this->appname ".__CLASS__."->".__FUNCTION__.": ROLLBACK");}
   				$this->execSQL("ROLLBACK");

		   		$err = mysql_errno();
				if (!$err==0) {
					$this->taStatus = FALSE;	// transaction is NOK
					$errmsg = "$this->appname ".__CLASS__."->".__FUNCTION__.": An SQL-Error occurred: ".
					$err." ".mysql_error()." Statement: ROLLBACK" ;
					$errorStack->pushMsg($errmsg);
				} else {
					$this->taStatus = TRUE;
				}   		
		   		
	   		}
	   	}
   	}
	/**
	 * End a database transaction.
	 * This handles nested transactions. An SQL commit will be executed if the outermost transaction is closed.
	 *  
	 * @global type $errorStack
	 * @global type $traceLevel 
	 */
	public function endTransaction() {
   		global $errorStack;
   		global $traceLevel;
   		if ($this->transactionLevel==0) {
   			// error in transaction-nesting
   			$errorStack->pushMsg('GGF001E Tried to end a transaction when no transaction was open');
   		} else {
	   		$this->transactionLevel--;
   			if ($this->transactionLevel==0) {
				if ($this->taStatus == TRUE) {
   					if ($traceLevel>=2) { error_log_adv ("$this->appname ".__CLASS__."->".__FUNCTION__.": COMMIT");}
		   			$this->execSQL("COMMIT");
					$err = mysql_errno();
		   			if (!$err==0) {
				   		$this->taStatus = FALSE;	// new transaction is NOK
						//$errmsg = "$this->appname ".__CLASS__."->".__FUNCTION__.": An SQL-Error occurred: ".
						$errmsg = "Could not commit transaction. SQL-Error occurred: ".
						$err." ".mysql_error()." Statement: COMMIT" ;
						$errorStack->pushUsrMsg(1,$errmsg);
					} else {
						$this->taStatus = TRUE;
					}   		
	   			} else {
   					if ($traceLevel>=2) { error_log_adv ("$this->appname ".__CLASS__."->".__FUNCTION__.": ROLLBACK");}
		   			$this->execSQL("ROLLBACK");
					$err = mysql_errno();
		   			if (!$err==0) {
				   		$this->taStatus = FALSE;	// transaction is NOK
						$errmsg = "$this->appname ".__CLASS__."->".__FUNCTION__.": An SQL-Error occurred: ".
						$err." ".mysql_error()." Statement: ROLLBACK" ;
						$errorStack->pushMsg($errmsg);
					} else {
						$this->taStatus = TRUE;
					}   		
		   		
		   		}
	   		}
	   	}
   	}
	
}
?>