<?PHP
/**
 * A class to implement an application window. It will do both: display the web-page and 
 * process the user reaction, the request from the client. Base class for all windows using GGFControls. 
 * Note: I recommend generating new windows and updating the window layout with the
 * ReinHTML Dialog Designer http://www.reinhztml.eu .
 * 
 * @todo 
 * @package GGF
 * @version 4.0
 * @since 2.1
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2011 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlWindow {
	static $staticCallbacks = FALSE;
	protected $myContextID;
	protected $myModel = array();
	protected $ERModel;
	protected $windowTitle = "";
	protected $CSSURL ="GGFFormats.css";
	protected $pane; // container for controls
	protected $myContainerClass ="GGFControlPane"; //may be changed to a form container
	protected $percent_per_loop = 0; // for progressbar. see initProgressBar()
	protected $percent_last = 0;
	protected $trayNotes = FALSE; // do not support notes for window
	/*
	 * Note: To enable direct access via shortcut URLs, security mechanism have to be disabled
	 * See GGFContext->checkCallbackURL()
	 *
	 * @var boolean
	 */
	protected $shortCutEnabled=FALSE;

	/**
	 * 
	 * Create new window object. This is called from openWindowOn() and
	 * by the GGFDispatch script during processing a client request.
	 * @param integer $contextID - ID of the window context. Note a window can be opened several times simultaneosly during a session. Each with a different context.
	 */
	function __construct($contextID) {
		global $goodbyefile;
		global $invalidContextFile;
		global $traceLevel;
		
		if ($contextID == 0) {			  // if no context, exit (context's must be provided by callers)
			header('Location: GGFInvalidContext.php');
			exit;
		}
		//GGF3.0
		$this->ERModel = $_SESSION["_ERModel"];

		if ($contextID == 999999999) {			  // if no context, exit (context's must be provided by callers)
			// Note: here we must check if the user is logged on
			//       and if the class supports direct access

			if (!($this->directAccessURL()=="")) { // direct access to this window/dialog is supported
				$mc = $this->directAccessContext();
				if ($mc == 0) { // could not establish a context
	   				header('Location: '.$goodbyefile);
					exit;
				}
			} else {
				header('Location: '.$invalidContextFile);
				exit;		
			}
		} else {
			$this->myContextID = $contextID;
			$mc = &windowContext($this->myContextID,0);
		}
		// do not reset list of registered callback URL's here. Do this in open, just before initWindow
		$mc->save();
		if ($traceLevel>=2) { 
			error_log_adv("Info.  Context ".$this->myContextID." : new instance of ".get_class($this));
	   	}
		//GGF3.0	
		//$this->initWindow($mc);
   	}
	/*
	 * for future use
	 */   	
	function __destruct() {
   	}
   	                
	//---utility-----------------------------------------------------------------
	/**
	 * 
	 * For internal use only
	 */
	protected function saveModel() {
		$_SESSION["_amod".$this->myContextID] = $this->myModel; // this is a workaround for controlbrowser window
	}
		
   	/**
	 * 
	 * This interface should return true, if processing of data
	 * can be done and active controls should be enabled.
	 * @return boolean
	 */
   	public function dataPlausible() {
		// if true, Buttons can be clicked
		return TRUE;
	}
	/**
	 * 
	 * Sets the title of the window (usually shown in the window title of the browser)
	 * @param string $str
	 */
  	public function setWindowTitle($str) {
		$this->windowTitle = $str;
	}
 	
 	/**
 	 * 
 	 * padding / trimming a string to fixed length
 	 * @param string $string
 	 * @param integer $width
 	 * @return string
 	 */
 	protected function prettyString($string, $width) {
		$ret = substr($string, 0, $width);
		return $ret.str_repeat(" ", ($width - strlen($ret)));
	}

	/**
 	 * 
	 * Padding / trimming a row of strings to a fixed length each
 	 * @param array $fields
	 * @param array $colwidths
	 * @param string $delimiter
	 * @return string
 	 */
 	protected function prettyColumn($fields, $colwidths, $delimiter) {
		$ret = $this->prettyString($fields[0], $colwidths[0]);
		for ($i = 1; $i < count($fields); $i++) {
			$ret = $ret.$delimiter.$this->prettyString($fields[$i], $colwidths[$i]);
		}
		return $ret;
	}
	
	/**
	 * 
	 * call this from constructor, if you want to show a progressbar before the window is displayed.
	 * implement a long-lasting function by overwriting  $this->makeProgress()
  	 * Note: this currently does not work (is ignored) for browser windows and main windows that have the openBody()
  	 * function overwritten. See also class GGFControlProgressBar for an alternative solution.
  	 * 
	 * @param integer $increments - tells how often $this->makeProgress() will be called until work is finished and window will be opened
	 */
  	protected function initProgressBar($increments=10) {
		// Calculate how many percents to advance per loop
  		$this->percent_per_loop = 100 / $increments;		
		// Preset variable to remember the percentage of the previous loop
		$this->percent_last = 0;
	}
 	
	/**
	 * 
	 * Return the id of the context of the window object
	 */
	public function contextID() {
		return $this->myContextID;
	}
	
	/**
	 * Internal use only.
	 * Override this, if your window should have a different CSS class for  the HTML body
	 */	 		
 	public function bodyClass() { 
		return 'GGFControlWindow'; //for CSS
	}
	
  	
	/**
	 * 
	 * Returns true if the session contains a userid
	 */
	public function isLoggedOn() {
		// use this to protect callbacks
		if (!isset($_SESSION["userid"])) {
			return FALSE;
		}
		$user = $_SESSION["userid"];
		if (strcmp($user,"") == 0) return FALSE;
		return TRUE; 
	}
  	/**
	 * 
	 * Returns true if no user is logged on
	 */
	public function isLoggedOff() {
   		return ($this->isLoggedOn()== FALSE);
   	}
   	
   	/**
   	 * 
   	 * for future use
   	 */
	public function selectedMenu() {
		// this normally returns the first
		if (!isset($this->myModel["_selectedMenu"])) {
			$this->myModel["_selectedMenu"] = 0;
		}
		return $this->myModel["_selectedMenu"];
	}
 
   	/**
   	 * 
   	 * for future use
   	 */
	public function subMenu() {
		// give the name of the submenu, if one is open
		if (!isset($this->myModel["_subMenu"])) {
			$this->myModel["_subMenu"] = 0;
		}
		return $this->myModel["_subMenu"];
	}
	
	/**
   	 * 
   	 * Returns standard-text for a status bar
   	 */
	protected function windowStatus() {
		global $dbname;
		global $dbhost;
		if ($this->isLoggedOn()) {
			return " Logged in user:".$_SESSION["userid"]." at DB:".$dbname."@".$dbhost;
		} else {
			return "not logged on.";
		}
	}
	
	/**
	 * 
	 * Control the the behavior of the callbackURL function.
	 * If set to true, the GGFDispatcher is not used.
	 * 
	 * *internal use only*
	 * 
	 * This is used only if you to generate static HTML pages.
	 */
	static function setStaticCallbacksURLMode($noDispatch=FALSE) {
		GGFControlWindow::$staticCallbacks = $noDispatch; 
	}
	
	/**
	 * 
	 * This delivers a complete URL for a form or hyperlink callback to 
	 * a callback function in this (or a derived) class (via the GGF Dispatcher). 
	 * If StaticCallbacksURLMode is set, the callback name is considered to deliver a relatice URL.
	 * 
	 * @param string $callBackName
	 */
	public function callbackURL($callBackName) {
		
		if (GGFControlWindow::$staticCallbacks) {
			// create static URL for HTML-only Form generation 
			$url = $callBackName;
			;
		} else {
			//create an URL to the dispatcher
			$c = &windowContext($this->myContextID, "");
			$url = $c->callbackURL()."&_callback=".$callBackName;
			$c->regCallbackURL(substr($url,strpos($url, "GGFDispatch")));
			
		}
		return $url;
	}

	/**
	 * 
	 * For future use
	 */
	protected function modelObjectPrimaryKeyValuesString() {
		return "";
		// note: if the window should allow taking notes tied to the displayed model-object,
		// this method has to be overwritten and an object key has to be supplied here instead
		// of the empty string. THis can be generated with
		
		//	$objectType->primaryKeyValuesString($row),

		// where $objectType is the entitytype of the modelobject and $row is its DB row
		// the object key is a string that holds an array of primarykey values of an object
		// the values are SQL quoted and html encoded (with htmlentities($pkAtt->asSQL($objectRow),ENT_QUOTES,'iso-8859-1')
		// and separated by blanks (see class GGFObjectNotesRelationshipType, function filterFrom)
	}
	
	/**
	 * 
	 * Returns an empty string.
	 * Implementation in derived classes should return an URL that
	 * allows to open the window or dialog without going via the main window
	 * Note: This should only be used for applications that implement
	 * browser based authentication. See GGFauthenticate and GGFContext.
	 * @return string
	 */		
	public function directAccessURL() {
		// create a direct access url.
		// Normally that does only make sense in Dialogs 
		return ""; 
	}
	/**
	 * 
	 * this function is called when the window is activated with a direct Access URL
	 * Convention is that the request contains "pkvalue" when this function ist called.
	 * $_REQUEST["pkvalue"] is a primary key of the model object that allows the initModel function 
	 * to retrieve it (from the database) when the window/dialog is opened to be displayed in the window/dialog.
	 * Note: This should only be used for applications that implement
	 * browser based authentication. See GGFauthenticate and GGFContext.
	 * @return GGFContext
	 */
	protected function directAccessContext() {
		$mc = &windowContext(0,$_REQUEST["_classname"]);	
		$this->myContextID = $mc->contextID;
		$mc->model = array();
		$mc->model[0] = $_REQUEST["pkvalue"];		
		return $mc;
	}
	/**
	 * @deprecated
	 * 
	 */
	protected function addMenu($name, $callback, $validator, $target="_self", $tiptext="",  $extraHTML="") {
		// adds an entry to the window's menu
		$menu = $this->pane->named("_menu"); // every GGFWindow has one GGFMenu in its pane, named _menu
		$menu->add(new GGFMenuItem($name, $callback, $validator, $target, $tiptext,  $extraHTML)); 		
	}
	/**
	 * 
	 * Creates a pane with the contents of the system tray.
	 * This is an area in the lower right of a window with some standrd functionality (help  ...)
	 * @param GGFContext $mc
	 * @return GGFControlPane
	 */
	protected function systemTray($mc) {
		global $appname;

		global $webmasterMail;
		
		//$pane = new GGFSystemTrayPane($this,"_systemTray");
		$pane = new GGFNewLinePane($this,"_systemTray");		
		//$pane->setStyle('');	
		$pane->add(new GGFControlPane($this,"_customSystemTray")); 
		
		
		if ($this->trayNotes) {
		$ncolors = array("_black",
				"_blue",
				"_red",
				"_yellow");
		$nc = $ncolors[$this->notesType($mc)];
		
		
		$pane->add(new GGFMenuItem('<img src="GGFIcons/GGFnotes'.$nc.'.gif" width="16" height="16" border="0">',
		                           "eventAddNote",
		                           "",
		                           "View (and add) notes to this window or object",
		                           $target="_blank"
		                           )
		                           );
		}
		if ($this->shortCutEnabled) {
			$u = $this->directAccessURL();
			if (!($u == "") ) {
				$pane->add(new GGFImageHyperlinkfield("shortcut",$this->directAccessURL(),"GGFIcons/GGFworld.gif", 16,16, 
						"Copy this hyperlink to access the window from outside directly", 
						"  border:0; ","_blank"));
			}
		}

		$pane->add(new GGFImageHyperlinkfield("windowhelp", $appname."_help.htm#".$mc->className,"GGFIcons/GGFhelp.gif",16,16, 
					"Display help about this window", ' border:0; ', "_blank"));

		$pane->add(new GGFImageHyperlinkfield("feedback", "mailto:".$webmasterMail."?subject=Feedback to App:".$appname."/Window:".$mc->className, "GGFIcons/GGFsmile.gif", 16, 16,
					"Send your opinion about this window to the administrator", ' border:0; ', "_blank"));

		$pane->add(new GGFImageHyperlinkfield("trayhelp", $appname."_help.htm#_SystemTray", "GGFIcons/GGFinfo.gif", 16, 16, 
					"Display help about these icons", ' border:0; ', "_blank"));

		$pane->add(new GGFStaticHyperlinkfield("servertime", "", date("H:i"), 0, "Server Time", '', "_blank"));
		
		return $pane;
	}
	
	/**
	 * 
	 * Check if there are notes and which type they are.
	 * Called by systemTray($mc)
	 * @param GGFContext $mc
	 * @return integer
	 */
	protected function notesType($mc) {
   		// 

		global $db;
		global $errorStack;
		
		$nType = 0;   		
   		
   		// check for notes
   		$res = $db->execSQL("SELECT count(*) ".
   		" FROM GGFNote WHERE ".
   		" (windowclassname='".$mc->className."' AND objectkey='".$this->modelObjectPrimaryKeyValuesString()."' AND ispublic = 1) OR ".
   		" (windowclassname='".$mc->className."' AND objectkey='' AND ispublic = 1) OR ".
   		" (windowclassname='".$mc->className."' AND objectkey='".$this->modelObjectPrimaryKeyValuesString()."' AND ispublic = 0 AND userid='".$_SESSION["userid"]."') OR ".
   		" (windowclassname='".$mc->className."' AND objectkey='' AND ispublic = 0 AND userid='".$_SESSION["userid"]."') ");
		if (!$db->OK()) {
			//GGF3.2
			$errorStack->pushMsg("GGFControlWindow: Cannot read the notes for the window.");
			// not necessary to display error here, done in open
		} else {
			$row = $db->fetchRow($res);
			//print_r($row);
			//exit;
			if ($row["count(*)"] > 0) {
				$nType = 1;
			}
		}
		
		if ($nType > 0) { 
			if (!$this->modelObjectPrimaryKeyValuesString() == "") {
				// check for object notes
				$res = $db->execSQL("SELECT count(*) ".
   				" FROM GGFNote WHERE ".
		   		" (windowclassname='".$mc->className."' AND objectkey='".$this->modelObjectPrimaryKeyValuesString()."' AND ispublic = 0 AND userid='".$_SESSION["userid"]."') OR ".
   				" (windowclassname='".$mc->className."' AND objectkey='' AND ispublic = 0 AND userid='".$_SESSION["userid"]."') ");
				if (!$db->OK()) {
					$errorStack->pushMsg("GGFControlWindow: Cannot read the notes for the window.");
					// not necessary to display error here, done in open
				} else {
					$row = $db->fetchRow($res);
					//print_r($row);
					//exit;
					if ($row["count(*)"] > 0) {
						$nType = $nType + 1;
					}
				}
			} elseif (!$this->modelObjectPrimaryKeyValuesString() == "") {
				// check for object notes
				$res = $db->execSQL("SELECT count(*) ".
   				" FROM GGFNote WHERE ".
   				" (windowclassname='".$mc->className."' AND objectkey='".$this->modelObjectPrimaryKeyValuesString()."' AND ispublic = 1) OR ".
	   			" (windowclassname='".$mc->className."' AND objectkey='".$this->modelObjectPrimaryKeyValuesString()."' AND ispublic = 0 AND userid='".$_SESSION["userid"]."') ");
				if (!$db->OK()) {
					$errorStack->pushMsg("GGFControlWindow: Cannot read the notes for the window.");
					// not necessary to display error here, done in open
				} else {
					$row = $db->fetchRow($res);
					//print_r($row);
					//exit;
					if ($row["count(*)"] > 0) {
						$nType = $nType + 2;
					}
				}
			}
		}	
		
		return $nType;
	}
	
	/**
	 * returns the sorter object of the window. dummy implementation here
	 * 
	 * @return GGFSqlSorter 
	 */
	public function order() {
		return new GGFSqlSorter();
	}

	//---callback processing----------------------------------------------------

	/**
	 * 
	 * Callback function to attach a notice to the window.
	 * This is linked to the standard system tray.
	 * Requires an implementation of modelObjectPrimaryKeyValuesString().
	 */
	protected function eventAddNote() {
		$mc = &windowContext($this->myContextID,0);
		
		$mc->model = $this->myModel;
		$mc->save();
		//error_log_adv('ADDNOTE:'.print_r($this->myModel,TRUE));
		
		//GGF3.0
		$mc->openDialogOn("GGFNotesDialog", 
			array($mc->className,
			$_SESSION["userid"],
			//GGF3.0
			$this->modelObjectPrimaryKeyValuesString(),
			""
			)
		);
		exit;
	}
		
	/**
	 * 
	 * Interface of callback function to export model data to the client.
	 */
	protected function eventExport() {
	}
	
	/**
	 * 
	 * Internal use only.
	 */
	protected function eventDemoClicked() {
		//messageBox($this->myContextID,"This is a Demo. No functionality added.");
		//$this->open();
		exit;
	}

	/**
	 * 
	 * callback function to open a messagebox with help info about the system tray
	 */
	protected function eventSystemTrayHelp() { 
		// obsolete
		// Per default GGF windows offer a small set of links, the system tray.
		messageBox($this->myContextID,
		"The small set of icons on this window belong to the system tray. It contains the following functions:
		<br><span ".' style="font-size:20.0pt;font-family:Webdings" '.">&#157;</span> This allows to write down (and view) a note. Notes can be tied to the currently displayed object (database row), or may be general for the window. This allows you to create your personal context sensitive annotations.<br> Notes can be public (to be seen by everyone) or private (only for you).
		<br><span ".' style="font-size:20.0pt;font-family:Webdings" '."></span     > Although this is a hyperlink, you should not click on it. It provides a so-called 'direct access link'. This is something like a shortcut from outside of the application directly to your data. You can use your browser's 'copy shortcut' function to get an URL, that you can send per mail to someone else. With this URL the receiver (if he has access to the application) can directly open the current dialog with the same data, without a need to navigate through the application. It enables you to send references to database-records via e-mail. (this icon is visible only in dialogs that support this functionality) 
		<br><span ".' style="font-size:20.0pt;font-family:Webdings" '.">&#143;</span> Export the model-object in csv format. You may use your browsers 'save as'-function to store the data into a file. This file then can be imported into spreadsheets etc.
		<br><span ".' style="font-size:20.0pt;font-family:Webdings"'.">i</span      > Displays a context-sensitive help for the window.
		<br><span ".' style="font-size:20.0pt;font-family:Wingdings"'.">J</span     > Allows to send a feedback mail to the system administrator of the application.
		<br><span ".' style="font-size:20.0pt;font-family:Webdings"'.">i</span      > Displays this helpinfo for the system tray.",
				1,
				"");
		exit;
	}

	/**
	 * 
	 * callback function to close the window.
	 */
	protected function eventClose() {
   		// this is called when the window is to be closed
   		
		global $errorStack;
		global $goodbyefile;
		
		// check, if there are errors in the stack left that are yet to display
		if (!$errorStack->isEmpty()) {
			return $this->eventDisplayError();
		}
		
   		$myContext = &dialogContextWithFrom($this->myContextID,0,0,0);
   		$myContext->invalidate();
		
   		header('Location: '.$goodbyefile);
		exit;

	}
	/**
	 * 
	 * Display error messages on the error stack in an error message dialog.
	 * The function does not return.
	 * If the name of a callback function is given, 
	 * processing will continue there after the error message dialog os closed.
	 * @param string $returnCallback
	 */
	protected function eventDisplayError($returnCallback="") {
		$myContext = &windowContext($this->myContextID,0);
		$this->saveModel();			
		$myContext->openDialogOn("GGFControlErrorDialog", 0, $returnCallback);
		exit;
	}
	
	/**
	 * 
	 * processing arrives here from process-callbacks and
	 * processFormEvent
	 * when a _openHMenuXXXXXX callback was detected
	 */
	protected function eventOpenHMenu($menuIndex) {
		// remember menu to be opened on redisplay
		if (strcmp($this->myModel["_selectedMenu"],$menuIndex)==0) {
			$this->myModel["_selectedMenu"] = substr($menuIndex,0,-2);
		} else  {
			$this->myModel["_selectedMenu"] = $menuIndex;
		}
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();   	
	}
	/**
	 * Standard callback for processing form input.
	 */
	protected function processFormEvent() {
		// here we come wenn a form-button is clicked
		// tell the difference between buttons by their name ~ menuitem[0}
		// echo "GGFDialog.request data:";print_r($_REQUEST);
		global $errorStack;
		//$errorStack->pushMsg(__CLASS__."->".__FUNCTION__.": processing request ".print_r($_REQUEST, TRUE) );
		
		$buttons = array();
		$itr = $this->pane->paneIterator();

		$c = $itr->next();
		while (!$c == 0) {
			if ($c->isButton()) {
				// no need to check if button active handled by rendering and firewall
				array_push($buttons,$c);
			}
			$c = $itr->next();
		}
		// $errorStack->pushMsg("checking ".count($buttons)." buttons");			
		foreach($_REQUEST as $key => $val) {
			// if key begins with "_openHMenu" this is framework internal event
			if (strcmp(substr($key,0,10),"_openHMenu") == 0) { //is menu open request
				// extract menu index from request key
				$menuIndex = substr($key,10);
				// remember menu to be opened on redisplay
				return $this->eventOpenHMenu($menuIndex);
			}
			foreach ($buttons as $c) {
				// no need to check if button active here, handled by firewall
				$name = $c->name();
				//$errorStack->pushMsg("checking ".$name);			
				$xedname = $name.'_x';
				//$errorStack->pushMsg("<br>".__CLASS__."->".__FUNCTION__." comparing '".$key."' with '".$name."' and '".$xedname."'");
				if ((strcmp($name, $key) == 0) OR (strcmp($xedname, $key) == 0) ) {
				//if (0 == strcmp($xedname,$key)) {
					// $errorStack->pushMsg("<br>".__CLASS__."->".__FUNCTION__.$key."' equals '".$name."' or '".$xedname."'");
					$mc = &windowContext($this->myContextID,0);
					$mc->checkCallbackURL("Button:".$name); //accept registered buttons only
					/* @var $funct string function name */
					$funct = $c->callback();
					//error_log_adv("<br>".__CLASS__."->".__FUNCTION__.$key."' equals '".$name."' or '".$xedname."' calling:".$funct);
					if ($funct>"") {
						$this->$funct();
					}
					return;
				}
				if ("Demo:".$name == $key) {
					return;
				}
			} // all buttons
		}
		// no button found, programming error or hacking attack
		$errorStack->pushMsg(get_class($this)."->".__FUNCTION__.": cannot process request ".print_r($_REQUEST, TRUE) );
		
		$this->eventClose();
		return;
	}
		
	//----- Window processing-------------------------------------
 	//--- main entry point ---------

	/**
	 * 
	 * Opens the Window. The sequence is as follows:
	 *	$this->initModel($mc); // build/initialize myModel
 	 *	$this->initWindow($mc); // fill pane with controls
 	 *	$this->processRequest($mc); // read data from $_REQUEST into controls
 	 *	$this->processCallbacks($mc); // process callBacks if any
 	 *	$this->fillControls($mc); // fills controls with data
 	 *	$this->openHTML(); // sends data to client  
	 */
 	public function open() {
 		// this function is called from other windows or when re-entering the window
 		// the constructur will fetch the active context in the session (the caller must prepare the contextswitch)
 		global $errorStack;
 		global $invalidContextFile;
		global $traceLevel;
 		
 		if ($traceLevel>=2) { 
			error_log_adv("Info.  Context ".$this->myContextID." : ".get_class($this)."->open() ");
	   	}
 		
 		$mc = &windowContext($this->myContextID,0);
 		if ($mc->isValid) { 
			
 			$this->initModel($mc); // build/initialize myModel
 			//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); exit;}
		
 			// do not reset list of registered callback URL's because if this is a frameset, then initwindow will not bedone for frames when returning from a window open (no complete rendering triggered).
			$this->initWindow($mc); // fill pane with controls
 			
 			//GGF3.0
 			$this->fillControls($mc); // fill controls with data
 			
 			//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); exit;}
			//print_r($_REQUEST);
			$this->processRequest($mc); // read data from $_REQUEST into controls
			//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); exit;}
		
			//$mc->model = $this->myModel;
			//$mc->save();
 			$this->processCallbacks($mc); // process callBacks if any
 			//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.print_r($this->myModel[1],TRUE)); exit;}
				
			if (!$errorStack->isEmpty()) {
 				// if error in process, it makes sense to redisplay the window.
 				$this->eventDisplayError($returnCallback = "");
 			}
 			$this->fillControls($mc); //GGF3.1.1 : check if that makes sense to be called twice (see above)
 			
 			// check, if there are errors in the stack left that are yet to display
 			// normally this is to be checked in callbacks
 			if (!$errorStack->isEmpty()) {
 				// if error in fillControls, it makes no sense to continue.
 				// close the window )go back to parent, and if no parent exists say goodbye)
 				$this->eventDisplayError($returnCallback = "eventClose");
 			}
			$mc->model = $this->myModel;
			//error_log_adv(print_r($mc->model,TRUE));
 			$mc->save();
			
 			$this->openHTML();
			//error_log_adv ("last save:".print_r($_SESSION,TRUE));
			$this->saveModel();			
			//error_log_adv ("last page:".$_SESSION["_amod"]["_page"]);
 		} else {
 			header('Location: '.$invalidContextFile);
 			exit;			
 		}		
 	}

 	/**
 	 * 
 	 * Initialize the model object from the saved context in the session.
 	 * Called by this->open().
	 * May be overwritten. If you do so call parent function.
	 * May be needed for windows, that do not get their model from the caller
	 * but have to initialize it themselves for every new session.
 	 * @param GGFContext $mc
 	 */
 	protected function initModel($mc) {
		$this->myModel = $mc->model;
	}
	
	/**
	 * 
	 * This is where the appearance of the window is to be defined.
	 * Called by this->open().
	 * Derived classes must override this functions, but call parent.
	 * @param GGFContext $mc
	 */
	protected function initWindow($mc) {
		$this->pane = new $this->myContainerClass($this,"_main");
		$this->pane->add(new GGFMenu($this,"_menu"));
		// in concrete classes overwrite this method and call parent
		// add controls there
	}		

	/**
	 * 
	 * Process the client request input data from the user.
	 * (filling it into window control objects)
	 * @param GGFContext $mc
	 */
	protected function processRequest($mc) {
		// this function may be overwritten, if the pane's standard processing does not work here
		$this->pane->processRequest($mc);
		//error_log_adv("processeRequest");
	}

	/**
	 * 
	 * Process callbacks from the client request.
	 * Calls event function. Input data is already stored in control objects.
	 * @param GGFContext $mc
	 */
	protected function processCallbacks($mc) {
		// process callbacks in the URL (context already established)
		
		//echo "<br> in GGFControlWindow-processCallbacks:";
		
		// continue processing according to transaction
		//echo "GGFWindow processed callback:".$callback;
		//
		if (isset($_REQUEST["_callback"])) {
			$callback = $_REQUEST["_callback"];
			if ($callback>"") {
				//invoke event function
				// do not read controls here, because you might get here also returning from subdialog
				// echo "<br>Backtrace in GGFWindow:"; debug_print_backtrace();
				if (isset($_REQUEST["_returnedFrom"])) {
					$resultContextID = $_REQUEST["_returnedFrom"];
				} else {
					$resultContextID = "";
					//GGF3.0
					$this->readControls($mc);
					$mc->model = $this->myModel;
					$mc->save();   	
					//print_r($_REQUEST);
					//exit;
				}

				if (strcmp(substr($callback,0,10),"_openHMenu") == 0) { // this is a framework internal event
					// extract menu index from request key
					$menuIndex = substr($callback,10);
					return $this->eventOpenHMenu($menuIndex);
				}

				if ($resultContextID=="") {
					return $this->$callback(); // assume that it exists (responsibility of HTML; see renderMenu)
				} else {
					return $this->$callback($resultContextID); // we arrive her is in a sub-dialog returnResult($ok) has been called
					// note error stack to be handled in such callbacks above 
				}
			}
		} else {
			// unknown transaction, no transaction
			// don't open a dialog or sub-window
			return TRUE;
		}    
		
	}
	
	/**
	 * 
	 * Read the data from entry-field controls and selector-controls into
	 * the model object.
	 * Windows must not have input controls. Therefore this interface is not implemented here.
	 * This is called from processCallbacks() before calling callback functions. 
	 * Implementations should transfer the value of non-readonly entry controls into 
	 * $mc->model and $this->myModel[1]
	 * @param GGFContext $mc
	 */
	protected function readControls($mc) {
	}
	/**
	 * 
	 * Filling the controls with values from the model
	 * 
	 * This is called after processing callbacks, if no error occurred in callback-processing
	 * This has to prepare any data needed for openHTML, rendering the controls. This
	 * default implementation fills entry-fields, password entryfields  and singleselection
	 * controls like Listbox, Combobox and Radiobutton.
	 * Assumes that myModel[1] contains an array with values for the window controls
	 * If that is not the case, the method must be overwritten.
	 * 
	 * @param array $mc window context, provided by framework 
	 */
		
	protected function fillControls($mc) {
		// that is :basically filling the controls with values from the model
		
		// Note: here data needed by openHTML can be created/read from db. 
		// take care to store it into 
		// $mc->model

		// take myModel[1] and fill same-named controls with its data	
		$itr = $this->pane->paneIterator();
		$c = $itr->next();
		while (!$c == 0) {
			$cn = $c->name();
			if (isset($this->myModel[1][$cn])) {
				if ($c->isEntry()) {
						$c->setValue($this->myModel[1][$cn]);
				} elseif (in_array('GGFSelectionControl', class_parents($c))) {
					if (strcmp($c->selectionsType(),"array")==0) {
						$c->setSelection(array($this->myModel[1][$cn]));
					} else {
					$c->setSelection($this->myModel[1][$cn]);
				}
				} else {
				}
			}
			$c = $itr->next();
		}
		
	}


	//---window rendering----------------------------------------------------------------
	
 	/**
 	 * 
 	 * Render the window. Send HTML to client. 
 	 * Internal use only. This is called by open()
 	 */
 	protected function openHTML() {
 		// probably not to be overwritten
 		// note: the HTML document may consist of frames.
 		//       The URLS to open the frames must be generated with $this->callbackURL("eventOpenHTMLFramexx")
 		//       the methods eventOpenHTMLFramexx must exist and must echo the framedocuments
 		//       note: all data needed to create the frame-documents, must be already read
 		//       and stored in the context-model, this may be done in fillControls but note that
 		//       data needed by eventOpenHTMLFramexx functions must be stored in the context-model
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"  "http://www.w3.org/TR/html4/loose.dtd">';
 		echo "<html>";
 		echo "<head>";
 		$this->openHead();
		echo "</head>";
 		$this->openBody();
 		echo "</html>";
 	}
 		
	/**
	 * 
	 * Render and send window  head
	 */
	protected function openHead() {
		global $appname;
		global $faviconURL;
		
		$this->openHeadTitle();
		if (isset($faviconURL)) {
			echo '<link rel="icon" type="image/x-icon" href="'.$faviconURL.'">';
		}
		echo '<link rel="stylesheet" type="text/css" href="'.$this->CSSURL.'">';
		echo '<meta name="robots" content="nofollow">';
		$this->openHeadIE6Support();
 	}

	protected function openHeadTitle() {
		global $appname;
		if ($this->windowTitle>"") {
			echo "<title>".$this->windowTitle." </title>";
		} else {
			echo "<title>".$appname." </title>";
		}
	}
	
	protected function openHeadIE6Support() {
 		echo '<!--[if IE 6]>
<script type="text/javascript">
	checkOpen = function() {
		var elems = document.getElementById("GGFHMenu").getElementsByTagName("LI");
		for (var i=0; i<elems.length; i++) {
			elems[i].onmouseover=function() {
				this.className+=" menuOpen"; 
			}
			elems[i].onmouseout=function() {
				this.className="";
			}
		}
		var elems = document.getElementById("GGFHMenu").getElementsByTagName("input");
		for (var i=0; i<elems.length; i++) {
			elems[i].onmouseover=function() {
				this.className+=" menuOpen"; 
			}
			elems[i].onmouseout=function() {
				this.className="";
			}
		}
	}
	if (window.attachEvent) window.attachEvent("onload", checkOpen);
</script>
<![endif]-->';
		/* old:
		 	elems[i].onmouseout=function() {
				this.className=this.className.replace(new RegExp(" menuOpen\\b"), ""); 
			}
		*/
	}

 	/**
 	 * 
 	 * Render and send window body.
 	 * Will show a progress bar first if one has been initialied.
 	 * Long lasting processes can be implemented by overridung this function and
 	 * calling makeProgress() several times from here
 	 */
  	protected function openBody() {
 		// overwrite this for your window's contents
 		//echo '<body bgcolor='.$this->bgcolor().' >';
 		echo '<body class="'.$this->bodyClass().'" >';
 		
 		$this->showProgressBar(); // does only something if a progressbar has been initialized
 		$this->makeProgress();    // does only something if a progressbar has been initialized
		$this->hideProgressBar(); // does only something if a progressbar has been initialized

 		echo $this->pane->render();
  		if ($this->percent_per_loop > 0) {
			echo "</div>";
		}
 		echo "</body>";
 	}

 	
 	/**
 	 * Internal use only.
 	 * Shows a progress bar if it has been initialized with initProgressBar()
 	 */
	protected function showProgressBar() {
		// show progressbar if it has been initialized before		
		if ($this->percent_per_loop > 0) {
			// a progressbar has been initialized write status-box info
			// Flush all buffers
			ob_end_flush();  
			flush();
			echo '	<div id="status1" class="statusbox" 
			style="z-index:1; top: 10px; 
			border-width:4px; background-color:#C0C0C0; border-color:#696969; 
			border-style:outset; padding:5px;">
				<strong>Processing. Please wait ...</strong>
				<br>'.
				//$this->cbHTML.
				'
				<div class="mailbar" >
		  		<div class="baritems"> ';
		}
	}
	
	/**
	 * 
	 * This is a placeholder that can be overwritten in case you want to implement a long-lasting
  	 * process before the window is displayed and a progress bar. 
  	 * if you want to implement a long lasting process with a progressbar
  	 * call initProgressBar() from the window constructor and override this function 
  	 * by replacing the "sleep" call by code that executes a portion of your process.
  	 * See also class GGFControlProgressBarDialog for an alternative solution.  
	 */
  	protected function makeProgress() {
  		
  		// NOTE:
  		// 1. an Implementation should 
  		//    - call incrementProgressBar the number of times given with
  		//    - call initProgressBar from the window constructor
  		// 2. an implementation must update the controls or call fillControls itself to display 
  		//    any processing results
  		// 3. The errorstack will not be checked automatically after this function. If an error is detected.
  		//    you cannot call eventDisplayError because HTML-headers already have been sent.
  		//    therefore you must 
  		//    - check the errorstack yourself at the end of processing
  		//    - write error-info into some control of the window
  		
		// shows some dummy behaviour (WAITING) if progress bar has been initialized
		// otherwise this does nothing
  		if ($this->percent_per_loop > 0) {
	  		for($i=1;$i<=10;$i++) {
  				sleep(1); // simulate some processing
				$this->incrementProgressBar();
			}
  		}
	}
	

 	/**
 	 * 
 	 * Shows a progress bar if it has been initialized with initProgressBar()
 	 */
	protected function incrementProgressBar() {
		// call this NOT MORE OFTEN THAN the number of increments defined in "initProgressbar" 
		// increment progressbar , if any		
		if ($this->percent_per_loop > 0) {
				
			// Here are the commands to calculate the advance in percentages and print out the necessary progress
			// By flushing out images and an optional div showing the percentage in numbers
			$percent_now = $this->percent_last + $this->percent_per_loop;
			if($percent_now <= 100) {
				echo '<span class="percentbox" style="z-index:'.$percent_now.'; top: 50px;">'; 
				echo '
					'.$percent_now; 
				echo ' %</span>';
				$difference = $percent_now - $this->percent_last;
				for($j=1;$j<=$difference;$j++) {
					   echo '<img src="GGFShapes/mailerbar-single.gif" width="5" height="15">';
				}
				$this->percent_last = $percent_now;
			}       						
			// Final, flush the output of this loop, advancing the progressbar as needed
			flush()	;
			return; 						
		}
	}
	/**
	 * Internal use only. 
	 * Remove the progress bar as soon as the processing has finished.
	 */
	protected function hideProgressBar() {
		// hide progressbar , if any		
		if ($this->percent_per_loop > 0) {
			echo '
			</div>
			</div>
			</div>
			';
			// set up the pane for normal window endering
		
			echo '<div id="status2" class="statusbox" bgcolor="#008080"; style="z-index:101; 
			top: 0px;
			left: 0px;
			width: 100%;		
			margin-left: 0px;
			background-color:#008080
			">';		
		}
	}
	
	/**
	 * 
	 * This fills a selection control (i.e. a listbox) with data from a table that is related
	 * to the model object. The relationship must be defined in the ERModel. The filter can control,
	 * if all or a subset of the related entities will be shown.
	 * 
	 * @param GGFSelectionControl $controlName
	 * @param string $ERTypeName
	 * @param array $columns - array of the names of the attributes to be shown
	 * @param array $columnwidths - if specified each column will be Trimmewd or padded with blanks to the width given for it
	 * @param GGFSqlFilter $filter
	 * @param GGFSqlSorter $sorter
	 * @param boolean $addDefaultSorter
	 * @param array $valueFields (for future use)
	 */
 	protected function fillSelectionControlER($controlName, $ERTypeName, $columns, $columnwidths = array(), $filter = null, $sorter = null, $addDefaultSorter = true, $valueFields = array()) {
 		global $db, $errorStack;
		$c = $this->pane->named($controlName);
		$c->setPreformatted(TRUE);
		//$c->fillSelectionControlER($ERTypeName, $columns, $columnwidths, $filter, $sorter, $addDefaultSorter, $valueFields);
		//return;
		$et = $this->ERModel->entityTypeNamed($ERTypeName);
		if ($et == null) {
			$errorStack->pushMsg('Invalid entity type for '.$controlName.'.');
		}
		if (count($columns) > 1 && count($columnwidths) < count($columns)) {
			$errorStack->pushMsg('Invalid column-widths for '.$controlName.'.');
		}

		if ($filter == null) { $filter = new GGFSqlFilter(); }
		if ($sorter == null) { $sorter = new GGFSqlSorter(); }

		if ($addDefaultSorter) {
			$sorter->setCriteria(array_merge($sorter->getCriteria(), $columns));
		}
		
		$res = $db->execSQL($et->createSelect($columns, $filter, $sorter));

		if (!$db->OK() && $errorStack->isEmpty()) {
			$errorStack->pushMsg('Could not read '.$ERTypeName.' for '.$controlName.'.');
			return;
		} else {
			$options = array();
			$keys = array();

			if (count($columns) > 1) {
				while($row = $db->fetchRow($res)) {

					$option = array();
					foreach($columns as $column) {
						array_push($option, $row[$column]);
					}

					array_push($options, $this->prettyColumn($option, $columnwidths, '|'));
					if (count($valueFields) > 0) {
						
						/** @todo: implement */
						//array_push($keys, $et->primaryKeyValuesString($row, ','));
						foreach($valuesFields as $valueField){
							array_push($keys, $row[$valueField]);
						}
						
					} else {
						array_push($keys, $et->primaryKeyValuesString($row, ','));
					}
				}
			} else {
				while($row = $db->fetchRow($res)) {
					array_push($options, $row[$columns[0]]);
					if (count($valueFields) > 0) {
						
						/** @todo: implement */
						//array_push($keys, $et->primaryKeyValuesString($row, ','));
						//so to do
						foreach($valueFields as $valueField){
							//print_r($valueField." ");
							//array_push($keys, $valueField);
							
							array_push($keys, $row[$valueField]);
						}
						
						//array_push($keys, $valueFields);
						
					} else {
						array_push($keys, $et->primaryKeyValuesString($row, ','));
					}
				}
			}
			
			$c->setValue($options);
			$c->setKey($keys);
		}

 	}
	
}
?>