<?PHP
/**
 * This is the update dialog for the GGFDemo application and
 * it serves as a base class for dialogs that update database rows. 
 * 
 * @todo comment, cleanup, version, test
 * @package GGF
 * @version 3.4
 * @since 2.0
 * @author Gerald Zincke, Austria
 * @copyright 2005,2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlUpdateDialog extends GGFControlDialog {
	// GGF (c) 2005 - Gerald Zincke, Austria	

	protected $extraAttributesToUpdate = array();
	
	// assume the model[0] contains a primary key value and
	// model[1] an empty array at the beginning and then the DB-row
	
	function __construct($contextID) {
       	parent::__construct($contextID);
       	//GGF3.0
		$this->ETypeName = "user";
		$this->extraAttributesToUpdate = array();
   	}
   	
   	// BEGINN mod Dominik, 04.08.06 - extension update_scrolling 
   	
   	/**
   	 * validates if it is possible to browse through a list of update dialogs
   	 * parent window has to be a '*BrowserWindow' and must provide a list of rows to browse through
   	 * update dialog must not be called via an insert dialog
   	 */
   	public function mayBrowse() {
   		$mc = &windowContext($this->myContextID, 0);
		$parContext = $mc->parentContext();
		if (isset($parContext->model["_where"]) && isset($parContext->model["_order"])) { 
			$etNameFromFilter = $parContext->model["_where"]->type()->name();
			if ((strcmp($this->ETypeName,$etNameFromFilter) == 0) 
				|| (strcmp($this->ETypeName."_expanded",$etNameFromFilter) == 0)
				|| (strcmp($this->ETypeName."_expanded",$etNameFromFilter."_expanded") == 0)) {
					return true;
				}
		}
   		return false;		// parent Window is not a Browser window 
   	}

   	protected function getParentFilterCount() {
   		$mc = &windowContext($this->myContextID, 0);
		$parContext = $mc->parentContext();
		if (isset($parContext->model["_where"])) {
			return $parContext->model["_where"]->count();
		} else {
			return 0;
		}
   	}
   	
   	public function canBrowseForward() {
   		if ($this->myModel['_offset'] >= 0) {
			return ($this->myModel['_offset'] < $this->getParentFilterCount() - 1) && $this->mayBrowse();
   		} else {
   			return false;
   		}
   	}
	
	public function canBrowseBack() {
		return ($this->myModel["_offset"] > 0) && $this->mayBrowse();
	}
	
	protected function initWindow($mc) {
		parent::initWindow($mc);
		//print_r($this->pane);
		//$formarea = $this->pane->named("_mainform");
		//$formarea->add(new GGFStaticfield("", 'Type updates and click OK.'));

		
		//$formarea->closeTable();
	}

	protected function systemTray($mc) {
		$st = parent::systemTray($mc);
		$pane = $st->named("_customSystemTray");
		
		$pane->add(new GGFImagePushbutton('_first', '', 'GGFIcons/GGFfirst.gif', 'eventBrowseFirst', 'canBrowseBack', 16, 'click to view the first element'));
		$pane->add(new GGFImagePushbutton('_prev', '', 'GGFIcons/GGFprev.gif', 'eventBrowsePrev', 'canBrowseBack', 16, 'click to view the previous element'));
		$pane->add(new GGFImagePushbutton('_next', '', 'GGFIcons/GGFnext.gif', 'eventBrowseNext', 'canBrowseForward', 16, 'click to view the next element'));
		$pane->add(new GGFImagePushbutton('_last', '', 'GGFIcons/GGFlast.gif', 'eventBrowseLast', 'canBrowseForward', 16, 'click to view the last element'));
		return $st;
	}

	/**
	 * createUPDATE supports also composite keys
	 *
	 * @todo testing
	 */
	protected function createUPDATE() {
		//create the update statement , with data from controls
		//check input validity here
		
		//GGF3.2.2
		$sql = "UPDATE ".$this->ETypeName." SET ";
		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
   		$pk = $et->primaryKey();
   		
		$atts = $et->attributeNames();
		$c = "";
		foreach ($atts as $an) {
			if (in_array($an,$pk) ) {
			} else {
				$att = $et->getAttributeNamed($an);
				//print_r($an);
				
				$control = $this->pane->named($an);
				
				
				if ($control) {
					//$row = array($an => $control->value()); old workaround , f no database row
					
					$row = $this->myModel[1]; // read by read controls
					$sql = $sql.$c." ".$an."=".$att->asSQL($row);
					if ($c=="") { 
						$c = ", "; 	
					}
					
				}
			}
		}
		
		// add extraAttributesToUpdate 
		foreach($this->extraAttributesToUpdate as $extraAtt) {
			if (array_key_exists($extraAtt, $this->myModel[1])) {
				$sql = $sql.$c." ".$extraAtt."= '".$this->myModel[1][$extraAtt]."'";
				if ($c=="") {
					$c = ", ";
				}
			}
		}
		
		$sql = $sql." WHERE ";
		$and = "";
		/*foreach ($pk as $pkname) {
			$row[$pkname] = $this->myModel[0]; // this does not work for tables with composite keys
			$att = $et->getAttributeNamed($pkname);
			$sql = $sql.$and.$pkname."=".$att->asSQL($row);
			$and = " AND ";
		}*/
		$key = explode(',', $this->myModel[0]);
		$idx = 0;
		foreach ($pk as $pkname) {
			$row[$pkname] = $key[$idx];
			$att = $et->getAttributeNamed($pkname);
			$sql = $sql.$and.$pkname."=".$att->asSQL($row);
			$and = " AND ";
			$idx++; 
		}
			 
		return $sql;
	}

	
	protected function readControls($mc) {
	        //echo "called"; exit;
		parent::readControls($mc);
		//$this->myModel[1]['password'] = $this->pane->named("password")->value();
		//$this->myModel[1]['firstname'] = $this->pane->named("firstname")->value();
		//$this->myModel[1]['lastname'] = $this->pane->named("lastname")->value();
		//$this->myModel[1]['level'] = $this->pane->named("level")->value();
		
		// additionally read level (despite its readonly)
		if ($this->pane->named('level')) {
			$this->myModel[1]['level'] = $this->pane->named('level')->value();
		}
		$mc->model = $this->myModel;
		$mc->save();
		//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); debug_print_backtrace(); exit;}
		
	}
	
	protected function fillControls($mc) {
		parent::fillControls($mc);		
		//error_log_adv('fill:'.print_r($this->myModel,TRUE));
		//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); exit;}
		
	}

	

	//---callbacks--------------------------
	
	// BEGINN mod Dominik, 04.08.06 - extension update_scrolling 
	
	protected function checkForUpdate() {
		if (count(array_diff_assoc($this->myModel[1], $this->myModel["_preimage"])) > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	/** @todo: testing */
	protected function refreshBrowseModel() {
		
		global $db;
		global $errorStack;
		$mc = &windowContext($this->myContextID, 0);
		$parContext = $mc->parentContext();
		
		$filter = $parContext->model['_where'];
		$sorter = $parContext->model['_order'];
		$columns = $parContext->model['_columns'];
		$et = $filter->type();
		$pk = $et->primaryKey();
			
   		$sql = $et->createSelect(
   			$columns,
   			$filter,
   			$sorter, 
   			$this->myModel['_offset'] + 1, // see entity type create select "page/pagesize"..
   			1);
		

		$res = $db->execSQL($sql);
		if (!$db->OK()) {
			$errorStack->pushMsg("GGFControlUpdateDialog: Cannot fetch row for ".$this->ETypeName." record.");
			return;
		} else {
			$row = $db->fetchRow($res);
			$pkValues = array();
			foreach($pk as $apk) {
				array_push($pkValues, $row[$apk]);
			}
			$this->myModel[0] = implode(',', $pkValues);
			
			$sql = $this->createSELECT();
			$res = $db->execSQL($sql);
			if (!$db->OK()) {
				$errorStack->pushMsg("GGFControlUpdateDialog: Cannot read ".$this->ETypeName." record.");
				return;
			} else {
				$row = $db->fetchRow($res);
				$this->myModel[1] = $row;	// assign data from first row
				$this->myModel["_preimage"] = $row;	// assign data from first row
			}
		}
		$this->fillControls($mc);
	}
	
	/** @todo rework: case if rows get inserted meanwhile !!! */
	protected function getPosition() {

		$mc = &windowContext($this->myContextID, 0);
		$parContext = $mc->parentContext();
		if (isset($parContext->model["_where"]) && isset($parContext->model["_order"])) { 
			$etNameFromFilter = $parContext->model["_where"]->type()->name();
			if ((strcmp($this->ETypeName,$etNameFromFilter) == 0) 
				|| (strcmp($this->ETypeName."_expanded",$etNameFromFilter) == 0)
				|| (strcmp($this->ETypeName."_expanded",$etNameFromFilter."_expanded") == 0)) {	
					$pk = $parContext->model["_where"]->type()->primaryKey();	// fetch pk of record
					$page = $parContext->model["_page"];
					$pagesize = $parContext->model["_pagesize"];
					$pos = ($page - 1) * $pagesize;
					$val = array();
					foreach($parContext->model["_list"] as $rec) {	// supports composite keys
						$val = array();
						foreach($pk as $aKey) {
							array_push($val, $rec[$aKey]);
						}
						if (strcmp($this->myModel[0],implode(',', $val))==0) {
							return $pos;
						} else {
							$pos++;
						}
					}
				} else {
					return -1;
				}
		}
	}
	
	protected function browseFirst() {
		if ($this->myModel["_offset"] > 0) {
			$this->myModel["_offset"] = 0;
			$this->refreshBrowseModel();
		}
	}

	protected function eventBrowseFirst() {
		if ($this->checkForUpdate()) {	// check if db has to be updated
			$mc = &windowContext($this->myContextID, 0);
			$mc->model = $this->myModel;
			$mc->save();
			// $mc->openDialogOn("NavNotificationDialog", array(),	$cont = "eventBrowseFirstContinue");
			messageBox($this->myContextID,
			"You have made some changes to current data. Would you like to take over changes to database?",
			2, "eventBrowseFirstContinue");
			// results of dialog will be processed in eventBrowseFirstContinue
			exit;
			
		} else {	// no update of db necessary
			$this->browseFirst();
		}
	}
	
	protected function eventBrowseFirstContinue($subContextID) {
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// update of db necessary
			$this->saveModifications();;
			$this->browseFirst();
		} else {					// no update of db necessary - continue browsing
			$this->browseFirst();
		}
	}
	
	protected function browsePrev() {
		if ($this->myModel['_offset'] > 0) {
			$this->myModel["_offset"]--;		// browse to previous record
			$this->refreshBrowseModel();
		}
	}

	protected function eventBrowsePrev() {
		if ($this->checkForUpdate()) {	// check if db has to be updated
			$mc = &windowContext($this->myContextID, 0);
			$mc->model = $this->myModel;
			$mc->save();
			messageBox($this->myContextID,
			"You have made some changes to current data. Would you like to take over changes to database?",
			2, "eventBrowsePrevContinue");
			// results of dialog will be processed in eventBrowsePrevContinue
			exit;
			
		} else {	// no update of db necessary
			$this->browsePrev();
		}			
	}

	protected function eventBrowsePrevContinue($subContextID) {
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// update of db necessary
			$this->saveModifications();;
			$this->browsePrev();
		} else {					// no update of db necessary - continue browsing
			$this->browsePrev();
		}
	}

	protected function browseNext() {
		if ($this->myModel['_offset'] >= 0) {
			if ($this->myModel['_offset'] < $this->getParentFilterCount() - 1) {
				$this->myModel["_offset"]++;		// browse to next record
				$this->refreshBrowseModel();
			}
		}
	}

	protected function eventBrowseNext() {
		if ($this->checkForUpdate()) {	// check if db has to be updated
			$mc = &windowContext($this->myContextID, 0);
			$mc->model = $this->myModel;
			$mc->save();
			messageBox($this->myContextID,
			"You have made some changes to current data. Would you like to take over changes to database?",
			2, "eventBrowseNextContinue");
			// results of dialog will be processed in eventBrowseNextContinue
			exit;
			
		} else {	// no update of db necessary
			$this->browseNext();
		}		
	}

	protected function eventBrowseNextContinue($subContextID) {
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// update of db necessary
			$this->saveModifications();;
			$this->browseNext();
		} else {					// no update of db necessary - continue browsing
			$this->browseNext();
		}
	}
	
	protected function browseLast() {

		if ($this->myModel["_offset"] >= 0) {
			$count = $this->getParentFilterCount();
			if ($count > 0) {
				$this->myModel["_offset"] = $count - 1;
				$this->refreshBrowseModel();
			}
		}
	}

	protected function eventBrowseLast() {
		if ($this->checkForUpdate()) {	// check if db has to be updated
			$mc = &windowContext($this->myContextID, 0);
			$mc->model = $this->myModel;
			$mc->save();
			messageBox($this->myContextID,
			"You have made some changes to current data. Would you like to take over changes to database?",
			2, "eventBrowseLastContinue");
			// results of dialog will be processed in eventBrowseLastContinue
			exit;
			
		} else {	// no update of db necessary
			$this->browseLast();
		}	
	}

	protected function eventBrowseLastContinue($subContextID) {
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// update of db necessary
			$this->saveModifications();
			if ($this->ok) {
				$this->browseLast();
			} else {
				return;
			}
			
		} else {					// no update of db necessary - continue browsing
			$this->browseLast();
		}
	}
	
	// END mod Dominik
	

	protected function eventExport() {
		global $db;
		global $errorStack;
		// the database record has not yet been read for this context
		$res = $db->execSQL($this->createSELECT($lock=FALSE));
	
		if (!$db->OK()) {
			$errorStack->pushMsg(__File__.__Line__.": Cannot read table for export.");
			$errorStack->pushUsrMsg(1,"Internal Error. Cannot export data.");
			// not necessary to display error here, done in open
		} else {
			while($row = $db->fetchRow($res)) {
				//GGF3.0
				foreach ($row as $val) {
					echo $val."\t";
				}
				echo "\r\n";
			}
		}
		exit;		
	}	
	protected function eventSelectLevel() {
		// open a lookupdialog to select from array
		$preselection = array($this->myModel[1]["level"]);
		$options = array("normal user","expert","administrator");
		// open GGFLookupDialog
		lookupBox($this->myContextID, $options,"eventSelectLevelReturn","Select user level",$preselection);
	}

	protected function eventSelectLevelReturn($subContextID) {
		// process selected level
   		$subContext = &windowContext($subContextID,0);

   		if ($subContext->result) { // OK, levelselected
   			$this->myModel[1]["level"] = $subContext->model[0][0]; // take the first selection in case multiple items were selected
	   	}
	}

	protected function eventOK() {
		// handles OK event
		$this->saveModifications();
		if ($this->ok) {
			$this->eventClose();
		}
	}
	
	//---open---------------
	
	/*protected function createSELECT($lock=FALSE) {
   		// the select statement to read the row
   		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
   		$pk = $et->primaryKey();
   		$sql = "SELECT * FROM ".$this->ETypeName.
   		" WHERE ".$pk[0]."='".$this->myModel[0]."' ";
   		if ($lock) {
   			return $sql." LOCK IN SHARE MODE";
   		} else {
   			return $sql;
   		}
	}*/
	
	/**
	 * createSELECT supports also composite keys
	 *
	 * @todo testing
	 */
	protected function createSELECT($columns = array(), $lock = FALSE) {
		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
		$pk = $et->primaryKey();
		$filter = new GGFERFilter($et);
		$sorter = new GGFSqlSorter();
		$addPk = false;
		
		if (count($columns) > 0) {
			// columns specified, add primary keys in selection
			$addPk = true;
		} else {
			// select all columns of entity Type (primary keys are selected as well)
			$columns = $et->attributeNames();
		}
		
		// consider composite keys
		$key = explode(',', $this->myModel[0]);
		$idx = 0;
		foreach($pk as $apk) {
			$filter->add(new GGFSqlFilterClause("AND", $apk, "=", $key[$idx]));
			$idx++;
		}
		
		$sql = $et->createSelect($columns, $filter, $sorter, /*$page*/ 0, /*$pageSize*/ 0, 
				/*$distinct*/TRUE, /*$addPrimaryKey*/$addPk);
		if ($lock) {
			return $sql." LOCK IN SHARE MODE";
		} else {
			return $sql;
		}
		
	}


		
	protected function initModel($mc) {
		// abstract, may be needed for windows, updating a model data structure
   		// prepare the model object
   		// debug_print_backtrace();
   		// read row, store in model
		global $db;
		global $errorStack;
		$this->myModel = $mc->model;
		//error_log_adv('--->'.__File__.__Line__.print_r($mc->model[1],TRUE));
		if (!isset($this->myModel['_offset'])) {
			$this->myModel['_offset'] = $this->getPosition();
		}

		if (isset($this->myModel[1]) AND (!$this->myModel[1] == 0)) {
			// do not read every time from db, because changes via subdialogs (see eventSelectLevel) would not work
		} else {
			// the database record has not yet been read for this context
			$res = $db->execSQL($this->createSELECT($columns = array(), /*$lock*/FALSE));
		
			if (!$db->OK()) {
				$errorStack->pushMsg("GGFControlUpdateDialog: Cannot read ".$this->ETypeName." record.");
				// not necessary to display error here, done in open
			} else {
				$row = $db->fetchRow($res);
				$this->myModel[1] = $row; // required here for processing in OK callback
				$this->myModel["_preimage"] = $row; // save this here for later check for double update				
				$mc->model = $this->myModel;
				$mc->save();
			}
		}
		//if (($this->myModel[1]['level'])=="") {error_log_adv('--->'.__File__.__Line__.print_r($this->myModel[1],TRUE)); exit;}
		
	}

	protected function openHeadTitle() {
		global $appname;
		if ($this->windowTitle>"") {
			echo "<title>".$this->windowTitle." </title>";
		} else {
			if ($this->ETypeName>"") {
				echo "<title>".$this->ETypeName."-update - ".$appname."</title>";
			} else {
				echo "<title>Update - ".$appname."</title>";
			}
		}	
	}
		
	protected function openFormContents() {
		echo $this->pane->render();
	}
	
	// BEGINN mod Dominik, 18.08.2006
	// --- save modifications concept ---------------
	
	/**
	 *
	 * Saves all changes made in an update dialog to db. Before updating db a verification of data is done.
	 */
	protected function saveModifications() {
		global $db;
		global $errorStack;
		
		// verification of data before Update. If verification fails a message is posted in $errorStack
		if ($this->validateData()) {
			$db->beginTransaction();	// beginn db transaction
			
			// read row again to comparing check if a parallel update of record happened
			$res = $db->execSQL($this->createSELECT($columns = array(), /*$lock*/ true));
			if (!$db->OK()) {
				$errorStack->pushMsg("GGFControlUpdateDialog: Cannot re-read ".$this->ETypeName." record.");
				$db->cancelTransaction();
				return;
			} else {
				$row = $db->fetchRow($res);
				if ($row == FALSE) {
					$errorStack->pushUsrMsg(1, "Cannot re-read ".$this->ETypeName." record. It may have been deleted in parallel.");
					$db->cancelTransaction();
					return;
				}
				// compare with row in model;
				$oldrow = $this->myModel["_preimage"];
				if (count(array_diff_assoc($row, $oldrow)) > 0) {
					// double update happened
					$errorStack->pushUsrMsg(1,"A parallel update of the record happened. Please retry.");
					$db->cancelTransaction();
					return;							// success = false;
				} else { // nothing changed ind db in meantime. Read the fields into the model
					$sql = $this->createUPDATE();
					// update and write protocol into history table
					$db->execSQL($sql, $this->ETypeName);
					
					if (!$db->OK()) {
						$errorStack->pushMsg("Cannot update the ".$this->ETypeName." record.");
						$db->cancelTransaction();
					} else {
						$db->endTransaction();
						if ($db->OK()) {
							$this->ok = TRUE;		// success = true;
						} // else
					} // else
				} // else
			} // else
		} // else
		
	}
	
	// END mod Dominik
}
?>