<?PHP
/**
 * This implements a dialog to perform a long-lasting transaction with a progressbar
 * It first displays the progressbar, then error messages (if any), then opens the dialog.
 *
 * Sample: Opening a dialog with progressbar from a window event handler function:
 
 	protected function eventMainProgress() {
		// test progressbar
		
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();
		// setup the modelobject with progressbar information
		$this->myModel["_progressBar"] = array();
		$this->myModel["_progressBar"]["progressBarPrompt"] = "Pocessing Mainview Function. Please wait ...";
		$this->myModel["_progressBar"]["increments"] = 20;
		$this->myModel["_progressBar"]["processingFunction"] = "makeProgress";
		$this->myModel["_progressBar"]["finalPrompt"] = "done";
		$mod = $this->myModel;
		$mc->openDialogOn("GGFControlProgressBarDialog",$mod , $cont="eventMainProgressReturn"  );
		exit;
   	}
   	
   	protected function eventMainProgressReturn($subContextID) {
   		$subContext = &windowContext($subContextID,0);
   		if ($subContext->result) {
   			$mc = &windowContext($this->myContextID,0);
   			// $this->refreshModel($mc);
   		}
	}

 *
 * To use it, create a derived class and re-implement the function makeProgress 
 * 
 * @todo  to be replaced by a control dialog
 * @package GGF
 * @version 3.6
 * @since 3.6
 * @author Gerald Zincke, Austria
 * @copyright 2008 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlProgressBarDialog extends GGFControlDialog {

	// model: as provided by the parent
	// if $this->myModel["_progressBar"] is set the following variables are taken:
	// $this->myModel["_progressBar"]["progressBarPrompt"]
	// $this->myModel["_progressBar"]["increments"]
	// $this->myModel["_progressBar"]["processingFunction"]
	// $this->myModel["_progressBar"]["finalPrompt"]
	// otherwise you must create a derived class and implement makeProgress and initModel
	
	protected $progressBarPrompt;
	public $increments;
	protected $processingFunction;
	protected $finalPrompt;
	protected $cbHTML;
	
	function __construct($contextID) {
       		parent::__construct($contextID);
       		$this->ETypeName = ""; // not used to update a domain object
       		
   	}

  	protected function makeProgress() {
  		// This is a placeholder that can be overwritten to implement a long-lasting
  		// process with a progress bar  
  		
  		// NOTE:
  		// 1. an Implementation should 
  		//    - call incrementProgressBar the number of times given with
  		//    - // $this->myModel["_progressBar"]["increments"]
  		// 2. an implementation must update the contenta of the "errors" control because
  		//    the errorstack will not be checked automatically after this function. If an error is detected.
  		//    you cannot call eventDisplayError because HTML-headers already have been sent.
  		//    therefore you must 
  		//    - check the errorstack yourself at the end of processing
  		//    - write error-info into the error control of the progressbarWindow
  		
		// showS some dummy behaviour (WAITING) if progress bar has been initialized
		// otherwise this does nothing
  		global $errorStack;
  		
  		//----- beginn dummy code
  		if ($this->percent_per_loop > 0) {
	  		for($i=1;$i<=$this->increments;$i++) {
  				sleep(1); // simulate some processing
  				$errorStack->pushUsrMsg(1,"made Progress $i");
				$this->incrementProgressBar();
			}
  		}
  		//----- end dummy code
  		
  		//----- this must be in every implementation:
  		// be sure to display errors
  		$msga = $errorStack->popAll();
  		if (count($msga) > 0) {
  			$this->ok = FALSE;
  		} else {
  			$this->ok = TRUE;
  		}
		$msgs = "";
		foreach ($msga as $msg) {
			$msgs = $msgs.$msg.'
';
		}
  		$this->pane->named("errors")->setValue($msgs);
  		
  	}

  	
 	protected function showProgressBar() {
		// show progressbar if it has been initialized before		
		if ($this->percent_per_loop > 0) {
			// a progressbar has been initialized write status-box info
			// Flush all buffers
			ob_end_flush();  
			flush();
			echo '	<div id="status1" class="statusbox" 
			style="z-index:1; top: 10px; 
			border-width:4px; background-color:#C0C0C0; border-color:#696969; 
			border-style:outset; padding:5px;">'
				.$this->progressBarPrompt.
				'<br>'.
				//$this->cbHTML.
				'
				<div class="mailbar" >
		  		<div class="baritems"> ';
		}
	}
	
  	protected function openBody() {
 		// overwrite this for your window's contents
 		//echo '<body bgcolor='.$this->bgcolor().' >';
 		echo '<body class="'.$this->bodyClass().'" >';
 		
 		
 		$this->showProgressBar(); // does only something if a progressbar has been initialized
 		$funct = $this->processingFunction;
 		$this->$funct();    // does the processing
		$this->hideProgressBar(); // does only something if a progressbar has been initialized

 		echo $this->pane->render();
  		if ($this->percent_per_loop > 0) {
			echo "</div>";
		}
 		echo "</body>";
 	}


	//---open---------------

		
	protected function initModel($mc) {
		// abstract, may be needed for windows, updating a model data structure
   		// prepare the model object
   		// debug_print_backtrace();
   		$this->myModel = $mc->model;
		//print_r($this->myModel["_progressBar"]["progressBarPrompt"]);

		$this->progressBarPrompt = "Processing. Please wait...";
		$this->increments = 10;
		$this->processingFunction = "makeProgress";
		$this->finalPrompt = "Processing finished";
		if (isset($this->myModel["_progressBar"])) {
			
			if (isset($this->myModel["_progressBar"]["progressBarPrompt"])) {
				$this->progressBarPrompt = $this->myModel["_progressBar"]["progressBarPrompt"];
			}
			if (isset($this->myModel["_progressBar"]["increments"])) {
				$this->increments =  $this->myModel["_progressBar"]["increments"];
			}
			if (isset($this->myModel["_progressBar"]["processingFunction"])) {
				$this->processingFunction = $this->myModel["_progressBar"]["processingFunction"];
			}
			if (isset($this->myModel["_progressBar"]["finalPrompt"])) {
				$this->finalPrompt = $this->myModel["_progressBar"]["finalPrompt"];
			}
		} 
		$this->initProgressBar($this->increments);
	}

	protected function initWindow($mc) {
		
		parent::initWindow($mc);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("prompt", $this->finalPrompt));

		 
		$formarea->newLine();
		$formarea->newRow(new GGFStaticfield("", "Errors:"));
		$ml = new GGFMultilineEntryfield($name="errors", 
				$value="", 
				$size=100, $vsize=5, 
				$maxlength=0, 
				$tiptext="Errors that occurred during the transaction",
				$extraHTML="");
		$ml->setReadonly();
		$formarea->newCell($ml);		
		$formarea->add(new GGFGenericControl('', '<embed src="GGFShapes\GGFfinished.wav" loop="false" />'));
		$formarea->newLine();
		
		$cb = $this->pane->named("_Cancel");
		$this->cbHTML = $cb->render();
		
		$buttonarea = $this->pane->named("_buttonarea");
		$buttonarea->clearControls(); // remove inherited button-definitions
		$buttonarea->add(new GGFPushbutton("_OK",     "OK",     "eventOK",    "", 60, "save data in database", ' width:80px; overflow:hidden '));

	}
		
	//---callbacks--------------------------	
	protected function eventOK() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();		
		$this->eventClose();	
	}

}
?>