<?PHP
/**
 * This dialog allows to select columns from a set. 
 * For GGF internal use.
 * 
 * @package GGF
 * @version 3.5
 * @since 3.5
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlColumnsDialog extends GGFControlSortDialog {
	

	// The model of this class contains 
	// model[0]: an array with the selected columns 
	// model[1]: array of all columns
	// model[2]: Title string
	// model[3]: an array of maximum columnsizes, indexed by columnname (may be empty)
	// open will display the strings in a listbox, do a default selection
	// on ok a new selection index array will be returned

	function __construct($contextID) {
       		parent::__construct($contextID);
       	}
	

	//---open---------------

	
	protected function openHeadTitle() {
		global $appname;
		echo "<title>".$appname.": ".$this->myModel[2]." Column Selection </title>";
	}
		
	protected function instruction() {
		return 'Select right columns for display and click Add , then OK.';
	}

	/**
	  * This creates a columnar pane containing buttons to manipulate selections
	  * May be overridden in derived classes to add additional functionality.
	  * Do not close the HTML table. This is done by the caller initWindow.
	  */
	protected function makeButtontable($buttonsize=100) {
		$buttontable = new GGFControlPane($this,"_buttontable");
		$buttontable->newRow(new GGFPushbutton("Add", 
		                         "Add", "eventAdd", "", $buttonsize, 
		                         "Add the selected entries on the right to the left"));
		$buttontable->newRow(new GGFPushbutton("AddSized", 
		                         "Add Sized", "eventAddSized", "", $buttonsize, 
		                         "Add the first selected entry on the right to the left - with a specified columns size "));
		$buttontable->newRow(new GGFPushbutton("SetSize", 
		                         "Set Size", "eventSetSize", "", $buttonsize, 
		                         "Set the columnsite for the first selected entry on the left"));
		$buttontable->newRow(new GGFPushbutton("Remove", 
		                         "Remove", "eventRemove", "", $buttonsize, 
		                         "Remove the selected entries on the left from the left"));
		$buttontable->newRow(new GGFPushbutton("Up", 
		                         "^", "eventUp", "", $buttonsize, 
		                         "Move the first selected entry on the left upwards"));
		$buttontable->newRow(new GGFPushbutton("Down", 
		                         "v", "eventDown", "", $buttonsize, 
		                         "Move the first selected entry on the left downwards"));
		$buttontable->newRow(new GGFPushbutton("AddAll", 
		                         "Add All", "eventAddAll", "", $buttonsize, 
		                         "Add all entries on the right to the left"));
		$buttontable->newRow(new GGFPushbutton("RemoveAll", 
		                         "Rem.All", "eventRemoveAll", "", $buttonsize, 
		                         "Remove all entries on the left"));
		return $buttontable;
	}
	
		
	protected function getCriteria() {
		$ca = array();
		foreach ($this->myModel[0] as $col) {
			array_push($ca,$col.":".$this->myModel[3][$col]);
		}
		return $ca;
	}
		
	
	//---callbacks--------------------------	
	protected function eventOK() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		
		// now build a new columns objects
		$this->myModel[0] = array();
		$this->myModel[3] = array();
		foreach ($this->myModel["_controls"]["criteria"] as $col) {
			$colsize = explode (":", $col);
			array_push($this->myModel[0],$colsize[0]);
			if (!$colsize[1]=="") {
				$this->myModel[3][$colsize[0]] = $colsize[1];
			}
		}
		//print_r($this->myModel[3]);
		
		$mc->model = $this->myModel;
		$mc->save();		
		$this->ok = TRUE;
		$this->eventClose();	
	}

	protected function eventAddSized() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		//print_r($this->myModel["_controls"]);
		// add a sort column selected at the right listbox
		$col = $this->myModel["_controls"]["rightselection"][0];
		if (!$col=="") {
			$colsize = explode (":", $col);
			messagePrompter ($this->myContextID, 
			"Size of column ".$colsize[0],  
			"eventAddSizedReturn", $value="0", /*$nrButtons*/ 2, 
			/*title*/ "Column Size Entry"); 
			exit;
		}
		$mc->model = $this->myModel;
		$mc->save();		
		//print_r($mc->model["_controls"]);
	}


	protected function eventAddSizedReturn($subContextID) {
		// process entered size
		
		$subContext = &windowContext($subContextID,0);
		if ($subContext->result) { // OK, size entered
			$col = $this->myModel["_controls"]["rightselection"][0]; // currently only the first one ist taken
			array_push ($this->myModel["_controls"]["criteria"] , $col.':'.(0+$subContext->model[1]));
	   	}
		$mc = &windowContext($this->myContextID,0);
	
		$mc->model = $this->myModel;
		$mc->save();		
	}

	protected function eventSetSize() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		//print_r($this->myModel["_controls"]);
		// add a sort column selected at the right listbox
		$col = $this->myModel["_controls"]["leftselection"][0];
		if (!$col=="") {
		
			$colsize = explode (":", $col);
			if (!$colsize[1]=="") {
				$val = $colsize[1];
			} else {
				$val = 0;
			}
		
			messagePrompter ($this->myContextID, 
			"Size of column ".$colsize[0],  
			"eventSetSizeReturn", $value=$val, 2, 
			"Column Size Entry"); 
			exit;
		}
		
		$mc->model = $this->myModel;
		$mc->save();		
		//print_r($mc->model["_controls"]);
		
	}


	protected function eventSetSizeReturn($subContextID) {
		// process entered size
		
		$subContext = &windowContext($subContextID,0);
		if ($subContext->result) { // OK, size entered
			$col = $this->myModel["_controls"]["leftselection"][0]; // currently only the first one ist taken
			$colsize = explode (":", $col);
			$index = array_search ($col, $this->myModel["_controls"]["criteria"]); 
			$this->myModel["_controls"]["criteria"][$index] = 
			   $colsize[0].':'.(0+$subContext->model[1]);
	   	}
		$mc = &windowContext($this->myContextID,0);
	
		$mc->model = $this->myModel;
		$mc->save();		
	}


}
?>