Drop database if exists Contacts; 
CREATE DATABASE Contacts;
USE Contacts;

DROP TABLE IF EXISTS Company;

CREATE TABLE Company (
  Company_ID 	integer NOT NULL AUTO_INCREMENT ,
  CompanyName 	varchar(64) NOT NULL,
  Street 		varchar(32) NOT NULL,
  City 			varchar(32) ,
  ZIPCode 		varchar(16) ,
  Country 		varchar(16) ,
  LastChange 	timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (Company_ID)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO Company SET Company_ID=1, CompanyName='Microsoft', City='Redmond', Country='USA';
INSERT INTO Company SET Company_ID=2, CompanyName='Apple', City='Cupertino', Country='USA';
INSERT INTO Company SET CompanyName='Salzach River Technology, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Salzach River Technology, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Salzach River Technology, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Salzach River Technology, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Salzach River Technology, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Salzach River Manufacturing, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Salzach River Manufacturing, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Salzach River Manufacturing, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Salzach River Manufacturing, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Salzach River Manufacturing, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Danube River Trading, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Danube River Trading, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Danube River Trading, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Danube River Trading, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Danube River Trading, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Danube River Logistics, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Danube River Logistics, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Danube River Logistics, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Danube River Logistics, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Danube River Logistics, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Victoria Lake Consulting, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Victoria Lake Consulting, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Victoria Lake Consulting, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Victoria Lake Consulting, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Victoria Lake Consulting, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Victoria Lake Technology, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Victoria Lake Technology, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Victoria Lake Technology, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Victoria Lake Technology, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Victoria Lake Technology, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Manufacturing, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Manufacturing, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Manufacturing, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Manufacturing, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Manufacturing, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Trading, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Trading, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Trading, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Trading, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Atlantic Sea Trading, GmbH ', Country='UK' ;
INSERT INTO Company SET CompanyName='Arctic Logistics, Inc. ', Country='USA' ;
INSERT INTO Company SET CompanyName='Arctic Logistics, Limited ', Country='Germany' ;
INSERT INTO Company SET CompanyName='Arctic Logistics, SA ', Country='Austria' ;
INSERT INTO Company SET CompanyName='Arctic Logistics, AG ', Country='Switzerland' ;
INSERT INTO Company SET CompanyName='Arctic Logistics, GmbH ', Country='UK' ;

select * from Company;

DROP TABLE IF EXISTS Person;

CREATE TABLE Person (
  Person_ID 	integer NOT NULL AUTO_INCREMENT,
  FirstName 	varchar(32) ,
  LastName 		varchar(32) NOT NULL,
  Title 		varchar(32) ,
  Company_ID 	integer NOT NULL,
  Department 	varchar(32) ,
  Position 		varchar(32) ,
  Phone 		varchar(16) ,
  Mobile 		varchar(16) ,
  EMail 		varchar(255),
  FOREIGN KEY (Company_ID) REFERENCES Company(Company_ID),
  LastChange timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (Person_ID)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO Person SET 
Person_ID=1, 
FirstName='Bill', 
LastName='Gates',
Position='Chairman',
Phone='001 123456789',
Company_ID=1;

INSERT INTO Person SET 
Person_ID=2, 
FirstName='Steve', 
LastName='Ballmer',
Position='CEO',
Phone='001 234567891',
Company_ID=1;

INSERT INTO Person SET 
Person_ID=3, 
FirstName='Tim', 
LastName='Cook',
Position='CEO',
Phone='001 345678912',
Company_ID=2;

select Person_ID, FirstName, LastName, Company_ID, Position, Phone, LastChange from Person;

# GGF standard tables 

DROP TABLE IF EXISTS user;

CREATE TABLE `user` (
  `userid` 			varchar(16) NOT NULL,
  `password_enc` 	varchar(32) NOT NULL,
  `lastname` 		varchar(32) ,
  `firstname` 		varchar(32),
  `preferences` text DEFAULT NULL,
  `email` 			varchar(255),
  `LastChange` 		timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  
PRIMARY KEY (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO user SET userid='test', password_enc=MD5('test');
INSERT INTO user SET userid='demo', password_enc=MD5('demo');

select userid, password_enc, lastchange from user;

DROP TABLE IF EXISTS GGFQuery;

CREATE TABLE GGFQuery
(
	id			integer AUTO_INCREMENT,
	owner  		VARCHAR(16) NOT NULL,
	ETypeName  	VARCHAR(64) NOT NULL,
	browser	    VARCHAR(64) NOT NULL,
	qname		VARCHAR(128) NOT NULL,
	filter  	TEXT,
	sorter		TEXT,
	thecolumns	TEXT,
	columnsize	TEXT,
	thechecksum	TEXT,
	PRIMARY KEY (id)
) ENGINE = InnoDB;

