<?PHP
/**
 * Class describing the ERmodel of the Contacts application
 *
 * It describes entitytypes "user", "company" and "person",
 * a relationshop type "Company employs Person" and an expanded
 * entitytype "Person_expanded" . It inherits the definition of 
 * the entitytype "query".
 * 
 * @package CTS
 * @version 1.0
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2012 Gerald Zincke
 */
class ContactsModel extends GGFERModel {
	protected function initialize() {
		global $ERModel;
		parent::initialize();
		
		/* create the model for the user table
		+---------------+--------------+------+-----+-------------------+-----------------------------+
		| Field         | Type         | Null | Key | Default           | Extra                       |
		+---------------+--------------+------+-----+-------------------+-----------------------------+
		| userid        | varchar(16)  | NO   | PRI | NULL              |                             |
		| password_enc  | varchar(32)  | NO   |     | NULL              |                             |
		| lastname      | varchar(32)  | YES  |     | NULL              |                             |
		| firstname     | varchar(32)  | YES  |     | NULL              |                             |
		| preferences   | text         | YES  |     | NULL              |                             |
		| email         | varchar(255) | NO   | UNI | NULL              |                             |
		| LastChange    | timestamp    | NO   |     | CURRENT_TIMESTAMP | on update CURRENT_TIMESTAMP |
		+---------------+--------------+------+-----+-------------------+-----------------------------+
		*/
		$user = new GGFEntityType("user");
		$user->addPrimaryKey(new GGFTextAttribute("userid"));
		$user->add(new GGFTextAttribute("userid"));
		$user->add(new GGFTextAttribute("password_enc"));
		$user->add(new GGFTextAttribute("lastname"));
		$user->add(new GGFTextAttribute("firstname","title/first name"));
		$user->add(new GGFTextAttribute("preferences"));
		$user->add(new GGFTextAttribute("email"));
		$user->add(new GGFTextAttribute("LastChange"));
		$user->setDefaultAttributeNames(array('userid','firstname','lastname','last_change'));		
		$this->add($user);
		
		/* create the model for the company table
		+-------------+-------------+------+-----+-------------------+-----------------------------+
		| Field       | Type        | Null | Key | Default           | Extra                       |
		+-------------+-------------+------+-----+-------------------+-----------------------------+
		| Company_ID  | int(11)     | NO   | PRI | NULL              | auto_increment              |
		| CompanyName | varchar(64) | NO   |     | NULL              |                             |
		| Street      | varchar(32) | NO   |     | NULL              |                             |
		| City        | varchar(32) | YES  |     | NULL              |                             |
		| ZIPCode     | varchar(16) | YES  |     | NULL              |                             |
		| Country     | varchar(16) | YES  |     | NULL              |                             |
		| LastChange  | timestamp   | NO   |     | CURRENT_TIMESTAMP | on update CURRENT_TIMESTAMP |
		+-------------+-------------+------+-----+-------------------+-----------------------------+
		*/
		$company = new GGFEntityType("Company");
		$company->addPrimaryKey(new GGFNumAttribute("Company_ID"));
		$company->add(new GGFNumAttribute("Company_ID"));
		$company->add(new GGFTextAttribute("CompanyName"));
		$company->add(new GGFTextAttribute("Street"));
		$company->add(new GGFTextAttribute("City"));
		$company->add(new GGFTextAttribute("ZIPCode"));
		$company->add(new GGFTextAttribute("Country"));
		$company->add(new GGFTextAttribute("LastChange"));
		$company->setDefaultAttributeNames(array('Company_ID','CompanyName','City','Country'));		
		$this->add($company);
		
		/* create the model for the person table:
		+------------+--------------+------+-----+-------------------+-----------------------------+
		| Field      | Type         | Null | Key | Default           | Extra                       |
		+------------+--------------+------+-----+-------------------+-----------------------------+
		| Person_ID  | int(11)      | NO   | PRI | NULL              | auto_increment              |
		| FirstName  | varchar(32)  | YES  |     | NULL              |                             |
		| LastName   | varchar(32)  | NO   |     | NULL              |                             |
		| Title      | varchar(32)  | YES  |     | NULL              |                             |
		| Company_ID | int(11)      | NO   | MUL | NULL              |                             |
		| Department | varchar(32)  | YES  |     | NULL              |                             |
		| Position   | varchar(32)  | YES  |     | NULL              |                             |
		| Phone      | varchar(16)  | YES  |     | NULL              |                             |
		| Mobile     | varchar(16)  | YES  |     | NULL              |                             |
		| EMail      | varchar(255) | YES  |     | NULL              |                             |
		| LastChange | timestamp    | NO   |     | CURRENT_TIMESTAMP | on update CURRENT_TIMESTAMP |
		+------------+--------------+------+-----+-------------------+-----------------------------+
		*/
		$person = new GGFEntityType("Person");
		$person->addPrimaryKey(new GGFNumAttribute("Person_ID"));
		$person->add(new GGFNumAttribute("Person_ID"));
		$person->add(new GGFTextAttribute("FirstName"));
		$person->add(new GGFTextAttribute("LastName"));
		$person->add(new GGFTextAttribute("Title"));
		$person->add(new GGFNumAttribute("Company_ID"));
		$person->add(new GGFTextAttribute("Department"));
		$person->add(new GGFTextAttribute("Position"));
		$person->add(new GGFTextAttribute("Phone"));
		$person->add(new GGFTextAttribute("Mobile"));
		$person->add(new GGFTextAttribute("EMail"));
		$person->add(new GGFTextAttribute("LastChange"));
		$person->setDefaultAttributeNames(array('Person_ID','FirstName','LastName','Phone','EMail'));		
		$this->add($person);
		
		/* create relationshiptype "Company employs Person"  */
		$company_person = new GGFRelationshipType(
				"Company employs Person",
				$company,array("Company_ID"),
				array(1,1,0,999999999),
				$person,array("Company_ID"));
		$this->addRel($company_person);
		
		/* create expaned entitytype "Person_expanded"  */
		$personExpanded = $person->createExpandedType();
		$personExpanded->getAttributeNamed('Company_ID.CompanyName')->setExternalName('Employer');
		$personExpanded->getAttributeNamed('Person.LastName')->setExternalName('Last Name');
		$personExpanded->setDefaultAttributeNames(
			array('Person.LastName', 'Person.FirstName', 'Person.Title', 'Person.EMail', 'Company_ID.CompanyName')
		);
		$this->add($personExpanded);
	}
}
?>