<?PHP
/**
 * Contacts browsing window
 * 
 * @package CTS
 * @version 1.0
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2012 Gerald Zincke
 */
class CTSContactBrowserWindow extends GGFControlBrowserWindow {

	function __construct($contextID) {
       		parent::__construct($contextID);
       		$this->ETypeName = "Person_expanded"; 	// initialize the name of the main model object class of the window
       		$this->enableCopy = true; 	// enables copy feature in browser window
   	}

	/**
	 * define event dialog-classes
	 */
	protected function initModel($mc) {
   		// prepare the model object
		parent::initModel($mc);
	
		$this->myModel["_updateDialogClass"] = "CTSContactUpdateDialog";
		$this->myModel["_insertDialogClass"] = "CTSContactInsertDialog";
		$this->myModel["_copyDialogClass"]   = "CTSContactInsertDialog";
		$this->myModel["_updateAfterInsert"] = false;
		$this->windowTitle = "Contacts - Browser ";
		$mc->model = $this->myModel;
		$mc->save();
	}

}
?>