<?PHP
/**
 * GGF Framework demo startup-file
 * 
 * @package GGF
 * @version 4.4
 * @since 4.3
 * @author Gerald Zincke, Austria
 * @copyright 2012 Gerald Zincke
 */
global $db;
global $errorStack;

$GGFPath = "GGF/"; 			// relative path to framework classes

// for debugging remove @ 
@require $GGFPath."GGF.php"; // startup GGF environment. 

// This section is to check your GGFSetup.php and should be removed for production
if (($errNo = $db->lastErrNo())==2002) {
	// provide an error message for the application admin
	$errorStack->pushUsrMsg(1,"GGF was not able to connect to the MySQL-server. Check if the DB-Server is up and running and if \$dbhost = '".$dbhost."' in GGFSetup.php is OK"); 
} elseif ($errNo==1044) {
	// provide an error message for the application admin
	$errorStack->pushUsrMsg(1,"GGF was not able to login to the MySQL-server. Check if the settings \$dbuser = '".$dbuser."' and \$dbpw in GGFSetup.php are OK");
} elseif ($errNo==1049) {
	// provide an error message for the application admin
	$errorStack->pushUsrMsg(1,"GGF was not able to open the database '".$dbname."' Check if setting \$dbname in GGFSetup.php is correct and the database exists at server ".$dbhost);
	$errorStack->pushUsrMsg(1,"You can create the database with the script GGF.sql or use a different database by changing \$dbname in GGFSetup.php.");
} elseif ($errNo>0) {
	// provide an error message for the application admin
	$errorStack->pushUsrMsg(1,"MySQL reported error number ".$errNo." accessing database '".$dbname."' at server ".$dbhost.'" ');
	$errorStack->pushUsrMsg(1,"More information is available in the logfile of your web server.");
}

// instantiate demo main window object
$mainWindow = new GGFDemoMainWindow(windowContext(0,"GGFDemoMainWindow")->contextID);
$mainWindow->open();		// open demo main window
?>