<?PHP
/**
 * Message prompter class.
 * Use the global function messagePrompter() to open it.
 * 
 * @package GGF
 * @version 3.2.2
 * @since 3.2.2
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFMessagePrompter extends GGFControlDialog {
	// array($msg, $value, $nrButtons, $title), 
	// model[0] contains the prompt message
	// model[1] the default value
	// model[2] the number of buttons (OK or OK+Cancel)
	// model[3] the window title
	 		
	function __construct($contextID) {
       		parent::__construct($contextID);
       		// $this->ETypeName = "user";
   	}
		
	//protected function bgcolor() { //html hexcode
	//	return '"#008080"'; //desktop green
	//}
	
	public function dataPlausible() {
		// if true, OK can be clicked
		return TRUE;
	}

	public function directAccessURL() {
		// create a direct access url.
		// this is used in GGFStandardMenuDialog 
		// but normally does only make sense in update dialogs 
		return ""; 
	}
	
	protected function readControls($mc) {
		$this->myModel[1] = $this->pane->named("value")->value();
		$mc->model = $this->myModel;
		$mc->save();
		
	}	
	
	protected function fillControls($mc) {
		// do nothing
	}
	
	protected function initWindow($mc) {
		parent::initWindow($mc); // has already an empty menu-pane
		// in concrete classes overwrite this method and call parent
		// add controls there
		
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Enter data and click OK."));
		$formarea->newLine();

		$formarea->newRow(new GGFStaticfield("", $this->myModel[0].":"));
		$ef = new GGFEntryfield("value", $this->myModel[1],    80, $maxlength=255, $tiptext="the value for the prompt");
		$formarea->newCell($ef);
		$formarea->closeTable();
		$formarea->newLine();
	}		
	
	//---events------------------------------------------------------
	
	protected function eventOK() {
		// here we want to come wenn the OK-button is clicked
		$this->ok = TRUE;
		$this->eventClose();	
		
	}
//---open---------------
	
	protected function openHeadTitle() {
		global $appname;
		echo "<title>".$appname.": ".$this->myModel[3]." </title>";
	}
		
}
?>