<?PHP
/**
 * This implements a dialog to update a sorter object
 * For GGF internal use.
 * 
 * @package GGF
 * @version 3.5
 * @since 3.5
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlSortDialog extends GGFControlDialog {

	// The model of this class contains 
	// model[0]: a GGFSorter object 
	// model[1]: array of columns
	// model[2]: Title string
	// open will display the strings in a listbox, do a default selection
	// on ok a new selection index array will be returned

	function __construct($contextID) {
       		parent::__construct($contextID);
       		$this->ETypeName = ""; // not used to update a domain object
   	}

	//---open---------------

		
	protected function initModel($mc) {
		// abstract, may be needed for windows, updating a model data structure
   		// prepare the model object
   		// debug_print_backtrace();
   		$this->myModel = $mc->model;
		
	}

	protected function initWindow($mc) {
		global $smallListPageSize;
		parent::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("prompt", "Select right columns for sortcriteria and click Add , then OK."));
		$formarea->newLine();
		$formarea->newRow(new GGFMultipleListbox($name="leftselection", 
				$options=array('red','green','blue', 'yellow', 'black'), 
	      			$selections=array('red','green'), $hsize=400, $vsize= $smallListPageSize, 
	      			$tiptext="select one or more colors", $extraHTML = ""));
		
		$bt = $this->makeButtontable();
		$bt->closeTable();             
		$formarea->newCell($bt);
		
		$formarea->newCell(new GGFMultipleListbox($name="rightselection", 
				$options=array('red','green','blue', 'yellow', 'black'), 
	      			$selections=array('red','green'), $hsize=400, $vsize= $smallListPageSize, 
	      			$tiptext="select one or more colors", $extraHTML = ""));
		
		
		$formarea->closeTable();
		$formarea->newLine();
	}

	/**
	  * This creates a columnar pane containing buttons to manipulate selections
	  * May be overridden in derived classes to add additional functionality.
	  * Do not close the HTML table. This is done in initWindow.
	  */
	protected function makeButtontable($buttonsize=100) {
		$buttontable = new GGFControlPane($this,"_buttontable");
		$buttontable->newRow(new GGFPushbutton("Add", 
		                         "Add", "eventAdd", "", $buttonsize, 
		                         "Add the selected entries on the right to the left"));
		$buttontable->newRow(new GGFPushbutton("AddDesc", 
		                         "Add DESC", "eventAddDESC", "", $buttonsize, 
		                         "Add the selected entries on the right with DESC (descending) to the left"));
		$buttontable->newRow(new GGFPushbutton("Remove", 
		                         "Remove", "eventRemove", "", $buttonsize, 
		                         "Remove the selected entries on the left from the left"));
		$buttontable->newRow(new GGFPushbutton("Up", 
		                         "^", "eventUp", "", $buttonsize, 
		                         "Move the first selected entry on the left upwards"));
		$buttontable->newRow(new GGFPushbutton("Down", 
		                         "v", "eventDown", "", $buttonsize, 
		                         "Move the first selected entry on the left downwards"));
		$buttontable->newRow(new GGFPushbutton("AddAll", 
		                         "Add All", "eventAddAll", "", $buttonsize, 
		                         "Add all entries on the right to the left"));
		$buttontable->newRow(new GGFPushbutton("RemoveAll", 
		                         "Rem.All", "eventRemoveAll", "", $buttonsize, 
		                         "Remove all entries on the left"));
		return $buttontable;
	}
	
	protected function getCriteria() {
		$sorter = $this->myModel[0];
		return $sorter->getCriteria();
	}
	
	protected function fillControls($mc) {
		// model[0]: a GGFSorter object 
		// model[1]: array of columns
		// model[2]: Title string
		// model["_controls"]: info about listbox selections
	
		parent::fillControls($mc);
		
		$this->pane->named("prompt")->setValue($this->instruction());
		
		if (!isset($this->myModel["_controls"]["criteria"])) {
			//print_r("--->>>>>>>");
					
			$this->myModel["_controls"]["criteria"] = $this->getCriteria();  
		}
		//print_r("--->>>>>>>");
		//print_r($this->myModel["_controls"]["criteria"]);
		$this->pane->named("leftselection")->setValue($this->myModel["_controls"]["criteria"]);
		
		if (!isset($this->myModel["_controls"]["leftselection"])) {
			$this->myModel["_controls"]["leftselection"] = array();
		}
		$this->pane->named("leftselection")->setSelection($this->myModel["_controls"]["leftselection"]);
	
		if (!isset($this->myModel["_controls"]["columns"])) {
			$cs = $this->myModel[1];
			natcasesort($cs);
			$this->myModel["_controls"]["columns"] = $cs ; 
		}

		$this->pane->named("rightselection")->setValue($this->myModel["_controls"]["columns"]);
		if (!isset($this->myModel["_controls"]["rightselection"])) {
			$this->myModel["_controls"]["rightselection"] = array();
		}
		$this->pane->named("rightselection")->setSelection($this->myModel["_controls"]["rightselection"]);
		
		$mc->model = $this->myModel;
		$mc->save();
	}

	protected function readControls($mc) {
		
		parent::readControls($mc);
		$this->myModel["_controls"]["criteria"] = $this->pane->named("leftselection")->value();
		$this->myModel["_controls"]["leftselection"] = $this->pane->named("leftselection")->getSelection();
		$this->myModel["_controls"]["rightselection"] = $this->pane->named("rightselection")->getSelection();
		$mc->model = $this->myModel;
		$mc->save();
		
	}

	protected function openHeadTitle() {
		global $appname;
		echo "<title>".$appname.": ".$this->myModel[2]." Sort Criteria </title>";
	}
		
	protected function instruction() {
		return 'Select right columns for sortcriteria and click Add , then OK.';
	}
		
	//---callbacks--------------------------	
	protected function eventOK() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		// handles OK event
		if ($this->ok = $this->validateData()) {
			// now build a new sorter object
			$sorter = new GGFSqlSorter();
			$sorter->setCriteria($this->myModel["_controls"]["criteria"]);
			$this->myModel[0] = $sorter;
			$mc->model = $this->myModel;
			$mc->save();		
			$this->eventClose();	
		}
	}
		
	
	protected function eventAdd() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		//print_r($this->myModel["_controls"]);
		// add a sort column selected at the right listbox
		foreach ($this->myModel["_controls"]["rightselection"] as $crit) {
			array_push ($this->myModel["_controls"]["criteria"] ,
			$crit);
		}
		$mc->model = $this->myModel;
		$mc->save();		
		//print_r($mc->model["_controls"]);
		
	}

	protected function eventAddAll() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		// print_r($this->myModel["_controls"]);
		// add a sort column selected at the right listbox

		$this->myModel["_controls"]["criteria"] = array();
		foreach ($this->myModel[1] as $col) {
			array_push ($this->myModel["_controls"]["criteria"],$col);		
		}
		$mc->model = $this->myModel;
		$mc->save();		
		
	}

	protected function eventAddDESC() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		
		// add a sort column selected at the right listbox
		// add selected item to the left listbox
		foreach ($this->myModel["_controls"]["rightselection"] as $crit) {
				array_push ($this->myModel["_controls"]["criteria"] ,
				$crit." DESC");
		}
		$mc->model = $this->myModel;
		$mc->save();		
	}

	protected function eventRemove() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		
		// remove a sort criteria selected at the left listbox
		
		foreach ($this->myModel["_controls"]["leftselection"] as $selitem) {
			$oldset = $this->myModel["_controls"]["criteria"];
			$newset = array();
			$j = 0;
			for ($i=0; $i < count($oldset); $i++) {
				// error_log_adv("lookat ".$i);

				if (!strcasecmp($selitem,$oldset[$i])==0) {
					$newset[$j] = $oldset[$i];
					// error_log_adv("put ".$newset[$j]." at ".$j);
					$j++;
					
				}
			}
			$this->myModel["_controls"]["criteria"] = $newset;
		}
		$mc->model = $this->myModel;
		$mc->save();		
		
	}
	
	protected function eventRemoveAll() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		// print_r($this->myModel["_controls"]);
		// add a sort column selected at the right listbox

		$this->myModel["_controls"]["criteria"] = array();
		$mc->model = $this->myModel;
		$mc->save();		
		
	}
	
	protected function eventUp() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		
		// move a sort criteria selected at the left listbox up
		$selitem = $this->myModel["_controls"]["leftselection"][0]; // currently only the first selected element is moved 
		if (!$selitem == "") {
			$oldset = $this->myModel["_controls"]["criteria"];
			$newset = array();
			$newset[0] = $oldset[0];
			for ($i=1; $i < count($oldset); $i++) {
				if ($selitem == $oldset[$i]) {
					$save = $newset[($i - 1)];
					$newset[($i-1)] = $oldset[$i];
					//error_log_adv("upped ".$oldset[$i]." at ".($i-1));
					$newset[$i] = $save;
					//error_log_adv("down ".$save." at ".$i);

				} else {
					//error_log_adv("put ".$oldset[$i]." at ".$i);
					$newset[$i] = $oldset[$i];
				}
			}
			$this->myModel["_controls"]["criteria"] = $newset;
		}
		$mc->model = $this->myModel;
		$mc->save();		
	}
	
	protected function eventDown() {
		// the controls have already been read into model["_control]
		$mc = &windowContext($this->myContextID,0);
		
		// move a sort criteria selected at the left listbox dowb
		$selitem = $this->myModel["_controls"]["leftselection"][0]; // currently only the first selected element is moved down 
		if (!$selitem == "") {
			$oldset = $this->myModel["_controls"]["criteria"];
			$newset = array();
			$nr = count($oldset) - 1;
			for ($i=0; $i <= ($nr - 1)  ; $i++) {
				if ($selitem == $oldset[$i]) {
					// oldset[$i] gehrt einen spter
					$newset[$i] = $oldset[($i + 1)];
					$oldset[($i + 1)] = $oldset[$i];
					$selitem = "++++++++"; // suppress furthe rmoves
				} else {
					//error_log_adv("put ".$oldset[$i]." at ".$i);
					$newset[$i] = $oldset[$i];
				}
			}
			$newset[$nr] = $oldset[$nr];

			$this->myModel["_controls"]["criteria"] = $newset;
		}
		$mc->model = $this->myModel;
		$mc->save();		
		
	}

}
?>