<?PHP
	/**
	 * shows errors from errorstack
	 * For GGF internal use.
	 * 
	 * @package GGF
	 * @version 4.5
	 * @since 1.0
	 * @author Gerald Zincke, Austria
	 * @copyright 2012 Gerald Zincke
	 * @license http://www.reinhtml.eu/ggf/license.html#top
	 */
	class GGFControlErrorDialog extends GGFControlDialog {
		
	protected $isFilled;
	
	function __construct($contextID) {
    	parent::__construct($contextID);
    	$this->ETypeName = 'user';
    	$this->extraAttributesToUpdate = array();
    	$this->isFilled = FALSE;
   	}
	function __destruct() {
    	parent::__destruct();
   	}

	protected  function adminIsLoggedOn() {
		global $applicationAdmin;
		// use this to protect callbacks
		if (!isset($_SESSION["userid"])) {
			return FALSE;
		}
		$user = $_SESSION["userid"];
		if (strcmp($user,$applicationAdmin)==0) return TRUE;
		return FALSE; 
	}
	
	protected function initModel($mc) {
		global $errorStack;
		$this->myModel = $mc->model;

		if (!isset($this->myModel[1])) {
			$em = $errorStack->popAll();
			$this->myModel = array(0,$em);
			$mc->model = $this->myModel;
			$mc->save();
		}
		
	}
	
	protected function fillControls($mc) {
		global $appname;
		global $errorStack;
		
		
		// note: fill-controls is called twice by the framework	
		if ($this->isFilled) {
			return ;
		} else {
			$this->isFilled = TRUE;
			$this->setWindowTitle("Error in ".$appname);
			$msgPane = $this->pane->named("detailed Messages");
			
			$em = $this->myModel[1];
			$msgs = array();
			
			foreach ($em as $txt) {
				if (!($this->adminIsLoggedOn())) {
					if (strcmp(substr($txt,0,3),'usr')==0 ) {
						$msgs[] = substr($txt,3);
					};
				} else {
					$msgs[] = $txt;
				}
			}
			if (count($msgs)==0) {
				$msgs[] = "An internal error occurred. Contact the system administrator.";
			}
		
			$i = 1;
			if (count($msgs)==1) {
				$this->pane->named("msg")->setValue(/*print_r($msgs, TRUE)*/$msgs[0]);   			
				$s = new GGFStaticfield("msg-".$i,"Submessage",""); 
				$s->setValue("none");
				$msgPane->newRow($s);
	   		} else {
		   		foreach ($msgs as $msg) {
		   			if ($i==count($msgs)) {
						$this->pane->named("msg")->setValue($msg);   			
		   			} else {
						$s = new GGFStaticfield("msg-".$i,"Submessage",""); 
						$s->setValue($msg);
						//print_r($msgs[$i]);
						$msgPane->newRow($s);
		   			}
		   			$i++;
		   		}
	   		}
		}			
   		
   	}
   	
	public function dataPlausible() {
		return TRUE;
	}
	
   	/**
   	** RD generated function initWindow
   	* create the layout definition of the window
   	*/
   	protected function initWindow($mc) {
		
		//*H1--generated code, do not touch. Use RD to update ---
		$this->CSSURL='GGFFormats.css';
		$this->windowTitle='Error in HDD Application';
		$cont0 = new GGFControlPane("_main","",""); $cont0->initP(array( "name" => "_main")); $cont0->resetP(array( "myContainer","controls","disabled","inTable","tabindex","bodyExtraHTML","frameID","paneType","isFrameset","style","Foreground","Background"));
		$cont0->setWindow($this);
		$this->pane = $cont0;
		   $cont1 = new GGFDialogFormPane("_mainform","",""); $cont1->initP(array( "name" => "_mainform")); $cont1->resetP(array( "demohtml","demohtml2","myContainer","controls","disabled","inTable","tabindex","bodyExtraHTML","frameID","paneType","isFrameset","style","Foreground","Background"));
		   $cont0->add($cont1);
		      $cont2 = new GGFNewLinePane("tit","",""); $cont2->initP(array( "name" => "tit","style" => "text-align:center;")); $cont2->resetP(array( "myContainer","controls","disabled","inTable","tabindex","bodyExtraHTML","frameID","paneType","isFrameset","Foreground","Background"));
		      $cont1->add($cont2);
		         $cont3 = new GGFStaticfield("s1","An Error has occurred",""); $cont3->initP(array( "name" => "s1","value" => "An Error has occurred","extraHTML" => "text-align:center;","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "#000000","fontFamily" => "default","fontSize" => "","fontStyle" =>  array("bold" => "1", "italic" => "", "underline" => "1"),)); $cont3->resetP(array( "size","tiptext","myContainer","tabindex","Background"));
		         $cont2->add($cont3);
		      $cont4 = new GGFEndPane("end:tit","",""); $cont4->initP(array( "name" => "end:tit")); $cont4->resetP(array( "value","size","extraHTML","tiptext","myContainer","tabindex","isDisabled","readonly","mandatory","Foreground","Background","fontFamily","fontSize","fontStyle"));
		      $cont2->add($cont4);
		      $cont1->newP();
		      $cont6 = new GGFStaticfield("msg","Hauptmessage",""); $cont6->initP(array( "name" => "msg","value" => "Hauptmessage","extraHTML" => " ","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "#B40431","fontFamily" => "default","fontSize" => "","fontStyle" =>  array("bold" => "1", "italic" => "", "underline" => ""),)); $cont6->resetP(array( "size","tiptext","myContainer","tabindex","Background"));
		      $cont1->newRow($cont6, '', '', '');
		      $cont1->newP();
		      $cont8 = new GGFFieldsetPane("detailed Messages","",""); $cont8->initP(array( "name" => "detailed Messages")); $cont8->resetP(array( "myContainer","controls","disabled","inTable","tabindex","bodyExtraHTML","frameID","paneType","isFrameset","style","Foreground","Background"));
		      $cont1->add($cont8);
		      $cont9 = new GGFEndPane("end:detailed Messages","",""); $cont9->initP(array( "name" => "end:detailed Messages")); $cont9->resetP(array( "value","size","extraHTML","tiptext","myContainer","tabindex","isDisabled","readonly","mandatory","Foreground","Background","fontFamily","fontSize","fontStyle"));
		      $cont8->add($cont9);
		      $cont1->newP();
		      $cont11 = new GGFControlPane("_buttonarea","",""); $cont11->initP(array( "name" => "_buttonarea")); $cont11->resetP(array( "myContainer","controls","disabled","inTable","tabindex","bodyExtraHTML","frameID","paneType","isFrameset","style","Foreground","Background"));
		      $cont1->newTable($cont11, '', '', '');
		         $cont12 = new GGFPushbutton("_OK","OK","60"); $cont12->initP(array( "callback" => "eventOK","validator" => "dataPlausible","name" => "_OK","value" => "OK","size" => "60","extraHTML" => "width:80px; overflow:hidden;","tiptext" => "continue","isDisabled" => "","readonly" => "","mandatory" => "")); $cont12->resetP(array( "myContainer","tabindex","Foreground","Background","fontFamily","fontSize","fontStyle"));
		         $cont11->add($cont12);
		      $cont13 = new GGFEndPane("end:_buttonarea","",""); $cont13->initP(array( "name" => "end:_buttonarea")); $cont13->resetP(array( "value","size","extraHTML","tiptext","myContainer","tabindex","isDisabled","readonly","mandatory","Foreground","Background","fontFamily","fontSize","fontStyle"));
		      $cont11->add($cont13);
		   $cont14 = new GGFEndPane("end:_mainform","",""); $cont14->initP(array( "name" => "end:_mainform")); $cont14->resetP(array( "value","size","extraHTML","tiptext","myContainer","tabindex","isDisabled","readonly","mandatory","Foreground","Background","fontFamily","fontSize","fontStyle"));
		   $cont1->add($cont14);
		$cont15 = new GGFEndPane("end:_main","",""); $cont15->initP(array( "name" => "end:_main")); $cont15->resetP(array( "value","size","extraHTML","tiptext","myContainer","tabindex","isDisabled","readonly","mandatory","Foreground","Background","fontFamily","fontSize","fontStyle"));
		$cont0->add($cont15);
		//****RD generated code, do not touch**********
		//*HDD*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*HDD*//
		//*H2--end of generated code, do not touch code above. Use RD to update ---
	} // end initWindow		
		//*H3--RD-generated event handlers below. do not remove this line.				
	/**
	** RD generated function
	* event handler for control Pushbutton(_OK, OK, 60)  
	* 
   	* @todo replace HDD-generated template-code by desired functionality
    * 
   	*/
	protected function eventOK() {
	 	parent::eventOK();
	}
	
	/**
	** RD generated function
   	* Evaluating results from dialogs opened by eventhandler for control Pushbutton(_OK, OK, 60)  
	* 
   	* @todo replace HDD-generated template code by desired functionality
   	* @param int ID of the context of the dialog
    * 
   	*/
	protected function eventOKContinue($subContextID) {
	 	// ---- begin template code ----
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// Yes clicked
			// insert code here
		} else {					// no clicked
			// insert code her
		}
		// ---- end template code ----
	}
					
					
				
	
} //end HDD generated class GGFControlErrorDialog
?>