<?PHP
/**
 * This class models a database query object containg columns, filter and sorter
 * For GGF internal use.
 *
 * @package GGF
 * @version 3.3
 * @since 3.3
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFQuery {

   	protected $row;
   	
	function __construct($owner /* userid */="",$ETypeName="",$classname="",$qname="",
		$filter="",$sorter="",$columns="", $columnsize=array()) {
		$this->row = array();
		$this->row["owner"] = $owner;
		$this->row["ETypeName"] = $ETypeName;
		$this->row["browser"] = $classname;
		$this->row["qname"] = $qname;
		$ermodel = $_SESSION["_ERModel"];
		if (!$ETypeName =="") {
			$et = $ermodel->entityTypeNamed($ETypeName);
		}
		if ($filter=="") {
			$this->row["filter"] = serialize(new GGFERFilter($et));
		} else {
			$this->row["filter"] = serialize($filter);
		}
		if ($sorter=="") {
			$this->row["sorter"] = serialize(new GGFSqlSorter());
		} else {
			$this->row["sorter"] = serialize($sorter);
		}
		if ($columns=="") {
			if ($et == "") {
				$this->row["thecolumns"] = serialize(array());
			} else {
				$this->row["thecolumns"] = serialize($et->attributeNames());
			}
		} else {
			$this->row["thecolumns"] = serialize($columns);
		}
		$this->row["columnsize"] = serialize($columnsize);
		if (!$this->row["ETypeName"] =="") {
			$this->row["thechecksum"] =  serialize($et);
		}
		
	}
	
	public function isValid() {
		if ($this->row["ETypeName"] =="") {
			return TRUE;
		} else {
			$ermodel = $_SESSION["_ERModel"];		
			return($this->row["thechecksum"] == serialize($ermodel->entityTypeNamed($this->row["ETypeName"])));
		}
	}
	
	public function setRow($row) {
		$this->row = $row;
	}
	
	public function row() {
		return $this->row;
	}

	public function owner() {
		return $this->row["owner"];
	}

	public function etypename() {
		return $this->row["ETypeName"];
	}

	public function qname() {
		return $this->row["qname"];
	}

	public function setQname($name) {
		$this->row["qname"] = $name;
	}

	public function filter() {
		return unserialize($this->row["filter"]);
	}

	public function sorter() {
		return unserialize($this->row["sorter"]);
	}
	
	public function columns() {
		return unserialize($this->row["thecolumns"]);
	}

	public function columnsize() {
		return unserialize($this->row["columnsize"]);
	}
	
}   
?>