<?PHP
/**
 * Implementation of a filter on tables described in the ER Model.
 * an ERFilter knows which entitytype it will applied to .
 *
 * extend to fit your needs
 * 
 * @todo comment, cleanup, version, test
 * @package GGF
 * @version 3.0
 * @since 3.0
 * @author Gerald Zincke, Austria
 * @copyright 2005 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFERFilter extends GGFSqlFilter {

protected $myEntitytype;

	function __construct($eType, $andor='AND') {
		$this->clauseOperator = $andor;
		$this->myEntitytype = $eType;
	}
	
	public function type() {
		return $this->myEntitytype;
	}
	
	public function count() {
		// says how many entities are selected by the filter
		global $db;
		global $errorStack;
		
		//error_log_adv(print_r($this->myEntitytype, TRUE));
   		
   		
   		//GGF3.1.1
   		$f = "";
   		$sf = $this->asSQL();
   		$jf = $this->myEntitytype->joinfilter()->asSQL();
   		if ($sf == "()" ) {
   			if ($jf != "()" ) {
		   		$f = ' WHERE ('.$jf.') ';
		   	} 
   		} else {
   			if ($jf != "()" ) {
   				$f = ' WHERE ('.$jf.') AND ('.$sf.')';
   			} else { 
   				$f = ' WHERE ('.$sf.') ';
   			}
   		}
   		
   		$sql = sprintf('SELECT count(*) FROM %s %s ',
   			implode(",", $this->myEntitytype->tableNames()),
			$f
			);
			
		$res= $db->execSQL($sql);
		if ($db->OK()) {
			$row = $db->fetchRow();
			return $row["count(*)"];
		} else {
			$errorStack->pushMsg("Cannot retrieve count for filter");
			return -1;
		}

	}
	
	

}
	