<?php
/*
 * GGFauthenticate.php
 *
 * sample for a web browser authentication handling
 * will not run out of the GGF-box
 * you will need to implement: person table, GGFWelcomeDialog, GGFChangeLogWindow and a file ChangeLog.htm
 *
 */

if (!isset($_SESSION["userid"]) || !isset($_SESSION["personid"])) {
	// routine was not yet executed, we don't know yet who the user is
	if (!isset($_SERVER["REMOTE_USER"])) {
		// the web server also does not know it
		header('HTTP/1.0 401 Unauthorized');
		// this causes the browser to display a login-dialog and retry the request
		exit;
	} else {
		// web browser has submitted a user-id to the server
		// here is assumed that the web-browser was configured to check, if userid and password are valid, this has been already done here
		// (Apache for instance can be told to ask a domain server via LDAP if the received userid/password are OK
		// or it can use its htaccess file to look for the valid userid/password)
		//
		// In a setup where this is not possible, we have to lookup somewhere else if userid/password are OK
		// for instance in a file or database table. This can be programmed 
		// <here> 
		// in PHP
		//
		global $db;
		global $errorStack;
		
		// this also assumes that we have a person-table in our database. Note that this table is not used for password validation in this example.
		// let us look, if there is already a record there for the user-id $_SERVER["REMOTE_USER"]
		
		$res = $db->execSQL("SELECT Person_ID, Name, First_Name, E_Mail, (".filemtime('ChangeLog.htm')." > UNIX_TIMESTAMP(ChangeLog_Timestamp)) AS 'gotoChangeLog' FROM person WHERE User_ID='".$db->escape_string($_SERVER["REMOTE_USER"])."'");
		// NOTE: the select above also checks if the changelog file was changed since the user's last login
		// the changelog is a text file that contains some info about the application
		
		if (!$db->OK()) {
			$errorStack->pushMsg("Error reading user table.");
		} else {
			$row = $db->fetchRow($res);
			
			if (isset($row['Person_ID'])) { // user has logged on before
				$_SESSION['userid'] = $_SERVER['REMOTE_USER'];
				$_SESSION['personid'] = $row['Person_ID'];
				if ($row['Name'] == '' || $row['First_Name'] == '' || $row['E_Mail'] == '') {
					// if we don't find all information about the user in the person-table, make sure that he will be prompted by a welcome dialog
					// the welcome dialog will ask for instance for his e-mail address
					if ($_REQUEST['_classname'] != 'GGFWelcomeDialog') {
						// now dispatch to the welcome dialog and then to the window which originally was requested
						header('Location: GGFDispatch.php?_classname=GGFWelcomeDialog&_contextID=999999999&followURL='.urlencode($_SERVER['REQUEST_URI']).'&pkvalue='.$_SESSION['personid']);
						exit;
					}
				} else if ($row['gotoChangeLog']) {
					// the changelog file was changed since the user was active the last time.
					// therefore show him the change log
					$res = $db->execSQL("UPDATE person SET ChangeLog_Timestamp=CURRENT_TIMESTAMP WHERE Person_ID='".$db->escape_string($_SESSION['personid'])."'");
					if (!$db->OK()) {
						$errorStack->pushMsg("Error setting user-ChangeLog-Timestamp.");
					}

					// now dispatch to the changelog window and then to the window which originally was requested
					header('Location: GGFDispatch.php?_classname=GGFChangeLogWindow&_contextID=999999999&followURL='.urlencode($_SERVER['REQUEST_URI']));
					exit;
				}
			} else { // user is first time logged in
				// if we don't find information about the user in the person-table, make sure that he will be prompted by a welcome dialog
				// the welcome dialog will ask for instance for his e-mail address
				
				$res = $db->execSQL("INSERT INTO person VALUES(0, '', '', '".$db->escape_string($_SERVER["REMOTE_USER"])."', 0, '', CURRENT_TIMESTAMP);", "person");
				if (!$db->OK()) {
					$errorStack->pushMsg("Could not create new user.");
				} else {
					$_SESSION["userid"] = $_SERVER["REMOTE_USER"];
					// now dispatch to the welcome dialog and then to the window which originally was requested
					header('Location: GGFDispatch.php?_classname=GGFWelcomeDialog&_contextID=999999999&followURL='.urlencode($_SERVER['REQUEST_URI']).'&pkvalue='.$db->lastInsertID());
					// the welcome dialog will ask for instance for his e-mail address
					exit;
				}
			}
		}
	}
}

?>