<?PHP 
/** 
 * Query-table browsing window. Queuries are objects that specify the appearance of
 * a database table in a GGFControlBrowserWindow.
 * This class requires a table GGFQuery in the database.
 * See GGF.sql. 
 * For GGF internal use.
 *  
 * @package GGF 
 * @version 4.0 
 * @since 3.3 
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top 
 */ 
class GGFQueryBrowserWindow extends GGFControlBrowserWindow {
	function __construct($contextID) {
		parent::__construct($contextID);
		$this->ETypeName = "GGFQuery"; // initialize the name of the main model object class of the window
		$this->enableCopy = false;
	}
	
	protected function getClass() {
		return __CLASS__;
	}
	
	protected function initWindow($mc) {
		parent::initWindow($mc);
		$listarea = $this->pane->named("_list");
		//print_r($listarea);
		$listarea->setViewCallback("eventView");
	}
	
	protected function createColumns() {
   		// the name of db columns to displayed
   		if (!isset($this->myModel["_columns"])) {
   		    	$et = $this->ERModel->entityTypeNamed($this->ETypeName);
   		    	$this->myModel["_columns"] = array('id', 'ETypeName', 'qname');
   		    	$this->myModel["_allcolumns"] = $et->attributeNames();  
   		}
	}
	
	protected function initModel($mc) {
		parent::initModel($mc);
		$this->myModel["_updateDialogClass"] = "GGFQueryUpdateDialog";
		$this->myModel["_insertDialogClass"] = "GGFQueryInsertDialog";
		$mc->model = $this->myModel;
		$mc->save();
	}
	/*
	 * checks for $this->myModel["_selection"] if that may be protected
	 */
 	protected function donotDelete() {
 		return FALSE;
 	}
 	
 	protected function eventInsert() {
		// no insert supported here
   	}

 	protected function eventView() {
		global $db;
		global $errorStack;

		// evaluate id of selected query
		
		$this->myModel["_selection"] = $_REQUEST["pkvalue"];
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();
		$qid = $this->myModel["_selection"];

		// reread the selected query to get the browser
		
		$res = $db->execSQL("SELECT id,browser FROM GGFQuery WHERE ID=".$qid);
		if (!$db->OK()) {
			$errorStack->pushMsg(__CLASS_.": Cannot read ".$this->ETypeName." record.");
			// not necessary to display error here, done in open
		} else {
			$q = $db->fetchRow($res);
		
			$mod = array($qid,array());
		
			$mc = &windowContext(0,0);	
			$mc->openWindowOn($q["browser"],$mod,"" );
			exit;
		}
   	}
   	
   	protected function openHeadTitle() {
		global $appname;
		echo "<title>".$appname."-Queries </title>";
	}

}
?>