<?PHP

/**
 * main window of the GGFDemo application
 *
 * This class also serves as a base class for othe application's main windows.
 * 
 * @todo comment, cleanup, version, test
 * @package GGF
 * @version 3.3
 * @since 2.0
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlMainWindow extends GGFControlWindow {
	// GGF (c) 2005 - Gerald Zincke, Austria	
	// This class implements the main window of the GGFDemo Application
	// a sample for a main window
 	protected $headerPane;
	protected $scrollPane;
	protected $footerPane;


	function __construct($contextID) {
       		parent::__construct($contextID);
   	}
	function __destruct() {
       		parent::__destruct();
   	}
   	
	
   	//---window definition-----------------------------------------

	protected function initWindow($mc) {
		// add controls there
		/*
		
		The window consists of three frames
		.------------------------------------------------------------------------------.
		| main frameset = $this->pane (containing frames 1,2 and 3)                    |
		|.----------------------------------------------------------------------------.| 
		|| frame1 = $this->headerPane                                                 ||
		|| (here the menu and the prompt are displayed)                               ||
		|:----------------------------------------------------------------------------:|
		|| frame2, frameset = $this->scrollPane                                       ||
		|| (this contains the main part of the window)                                ||
		||                                                                            ||
		|'----------------------------------------------------------------------------'|
		|| frame3 = $this->footerPane                                                 ||
		|| (display of window status)                                                 ||
		|'----------------------------------------------------------------------------'|
		'------------------------------------------------------------------------------'
		
		See also function openBody.
		*/
		global $appname;
		
		//for direct echo		
		$this->pane = new $this->myContainerClass($this,"_main");
		$this->pane->add(new GGFGenericControl("mainfs", '
			<frameset rows="100,*,25">  <!-- Frameset-Definition -->
			  <frame src="'.$mc->frameCallbackURL(1).'" name="headerPane" marginwidth="0" marginheight="0" frameborder="0" framespacing="0" border="0" scrolling="no" >
			  <frame src="'.$mc->frameCallbackURL(2).'" name="scrollPane" frameborder="0" framespacing="0" border="0">
			  <frame src="'.$mc->frameCallbackURL(3).'" name="footerPane" bgcolor="#E0E0E0" marginwidth="0" marginheight="0"  frameborder="0" framespacing="0" border="0">
			  <noframes>
			    Your Web-Browser cannot show frames. Use a modern browser.
			  </noframes>
			</frameset>'));

		//frame1
		$this->headerPane = new GGFControlPane($this,"_headerpane");
		$menu = new GGFMenu($this,"_menu");
		$menu->add(new GGFMenuItem("Logon",  		"eventLogon", 	"isLoggedOff",	"logon to database, allowing access to tables"));
		$menu->add(new GGFMenuItem("Logoff", 		"eventLogoff", 	"isLoggedOn",	"logoff, do not close the window"));
		$menu->add(new GGFMenuItem("Manage Users",	"eventUsers", 	"isLoggedOn",	"browse and update user-table", $target="_blank"));
		//GGF3.3
		$menu->add(new GGFMenuItem("Room-Reservations",	"eventRooms", 	"isLoggedOn",	"browse and update room-table", $target="_blank"));
		$menu->add(new GGFMenuItem("Queries",           "eventViewQueries", "isLoggedOn",	"view stored queries", $target="_blank"));
		
		
		// for testing the model generator
		$menu->add(new GGFMenuItem("Generate Code",		"eventGenerate", 	"",		"execute test application", $target="_blank"));
		$menu->add(new GGFMenuItem("Test Generated Code","eventTestGenerated", 	"",		"execute test application", $target="_blank"));
		
		$menu->add(new GGFMenuItem("ProgressBarDemo",		"eventMainProgress", 	"",		"test a GGFProgressBarDialog"));
		$menu->add(new GGFMenuItem("About",		"eventAbout", 	"",		"open the about dialog"));
		$menu->add(new GGFMenuItem("Close",  		"eventClose",	"",		"close window"));
		$this->headerPane->add($menu);
		$this->headerPane->newP();
		$this->headerPane->add(new GGFGenericControl("", '<h1>'));
		$this->headerPane->add(new GGFStaticfield("prompt", 'Welcome to '.$appname. ' !' ));
		$this->headerPane->add(new GGFGenericControl("", '</h1>'));
		$this->pane->addFrame(1,$this->headerPane);
		
		//frame2
		$this->scrollPane = new GGFControlPane($this,"_scrollPane");
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("prompt2", "This application has been created with GGF."));
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("prompt3", "Visit "));
		$this->scrollPane->add(new GGFStaticHyperlinkfield("homepage", "http://de.geocities.com/ggf_team/GGF.htm", "", 0, $tiptext="The homepage of the GGF project"));
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("description", 'This application
		shows some sample usage of the GGF framework. The menu-entries
		"Logon", "Logoff" and "Manage Users" show a simple user management GUI.
		You must login to use most of the menus. You can use user "admin" with
		password "admin" to do so.' ));
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("description2", 'The menu
		"Room-Reservation" shows a demo of an application that can be used by
		a restaurant to manage reservation of tables for dinner. It first
		displays a list of rooms and clicking on a room then shows a graphical
		display of the room with its tables. Just click on a table to reserve
		or unreserve it.'));
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("description4", 'The "Queries" menu
		shows a list of predefined queries on the user table, the room table and the 
		dining-table table. If you open it you will see tiny book-like icons. If you click 
		on one of them the query will be opened.'));
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("description3", 'The menu
		"Generate Code" is not only a demo but a tool to accelerate creation 
		of GGF applications. It takes a database table structure as input
		and generates all GGF classes required for complete database
		maintenance GUI. Note that the menu "Test Generated Code" will work
		only, if you save the code into the htdocs directory of the webserver
		where the GGFDemo application is installed.'));
		
		$this->scrollPane->newP();
		$this->scrollPane->add(new GGFStaticfield("description5", "Finally don't
		forget to explore the GGF system tray in the lower right corner of any
		window. Nearly all active user-elements in GGF are enriched with tip-text.
		So it makes sense to locate the mousepointer there and let it rest for a while."));
		
		$this->pane->addFrame(2,$this->scrollPane);

		//frame 3
		$this->footerPane = new GGFControlPane($this,"_footerPane");
		//GGF3.0
		$statusPane = new GGFControlPane($this,"_statusPane");
		$statusPane->add(new GGFStaticfield("status", $this->windowStatus(),0,"displays the current status of the window"));
		$this->footerPane->add($statusPane);
		$this->footerPane->add($this->systemTray($mc));
		$this->footerPane->setBodyExtraHTML('background-color:#E0E0E0; font-family:Arial; font-size:0.8em; border-width:2px; border-color:#E0E0E0; border-style:inset; padding:0px;');
		$this->pane->addFrame(3,$this->footerPane);
		
		$mc->model = $this->myModel;
		$mc->save();
	}		
   	//---event functions----------------------------------------
   	
	protected function eventLogon() {
		// open the logon panel.
		$myContext = &windowContext($this->myContextID,0);
		$myContext->openDialogOn("GGFLoginDialog", 0);
		exit;
	}	
	protected function eventLogoff() {
		$_SESSION["userid"] = "";
		// this may also force to close
		// invalidateContextStack();
		// $this->eventClose(); 
	}
	protected function eventUsers() {
		// open the logon panel.
		$myContext = &windowContext($this->myContextID,0);
		$myContext->openDialogOn("GGFControlBrowserWindow", 0);
	}
	//GGF3.3	
	protected function eventRooms() {
		// open the logon panel.
		$myContext = &windowContext($this->myContextID,0);
		$myContext->openDialogOn("GGFRoomBrowserWindow", 0);
	}
	
	protected function eventViewQueries() {
		// view all available queries
		
		$myContext = &windowContext(0,0);
		// print_r($subContext);
		//$mod = $this->myModel[0]; // the id of the room
		//print_r($mod);
		$myContext->openWindowOn("GGFQueryBrowserWindow", array() );
   	}
		
   	protected function eventGenerate() {
   		// open the modelgenerator
		global $dbhost;
		global $dbuser;
		global $dbpw;
		global $dbname;

		$myContext = &windowContext($this->myContextID,0);		

		$mod = array(0,array(	'server' => $dbhost,
				'server-login' => $dbuser,
				'server-password'=>$dbpw, 
				'dbname' => $dbname));
		$myContext->openDialogOn("GGFModelGeneratorDialog", $mod);
				
		
		exit;
   	}
   	
   	protected function eventTestGenerated() {
		// open a generated window
		messagePrompter ($this->myContextID, "enter browser classname",  "eventTestGeneratedReturn", $value="ggfnoteBrowserWindow", 2, "Class name Selection"); 
		exit;
	}

	protected function eventTestGeneratedReturn($subContextID) {
		// open selected generated window
		
		$subContext = &windowContext($subContextID,0);
		if ($subContext->result) { // OK, class name entered
			$myContext = &windowContext($this->myContextID,0);
			// print_r($subContext);
			$myContext->openDialogOn($subContext->model[1], 0);
	   	}
		exit;
	}
	
		
	protected function eventMainProgress() {
		// test progressbar
		
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();
		// prepare the model for the update dialog = key of row, and placeholder for row
		$this->myModel["_progressBar"] = array();
		$this->myModel["_progressBar"]["progressBarPrompt"] = "Pocessing Mainview Function. Please wait ...";
		$this->myModel["_progressBar"]["increments"] = 20;
		$this->myModel["_progressBar"]["processingFunction"] = "makeProgress";
		$this->myModel["_progressBar"]["finalPrompt"] = "done";
		$mod = $this->myModel;
		//print_r($mod);
		$mc->openDialogOn("GGFControlProgressBarDialog",$mod , $cont="eventMainProgressReturn"  );
		exit;
   	}
   	
   	protected function eventMainProgressReturn($subContextID) {
   		$subContext = &windowContext($subContextID,0);
   		
   		//if ($subContext->result) {
   			$mc = &windowContext($this->myContextID,0);
   			// $this->refreshModel($mc);
   		//}
	}
	
	
   	protected function eventAbout() {
   		// display the about dialog
		$myContext = &windowContext($this->myContextID,0);
		$myContext->openDialogOn("GGFControlAboutDialog", 0);
		exit;
   	}
	
	protected function eventClose() {
   		// this is called when the window is to be closed
   		
		global $errorStack;
		global $goodbyefile;
		
		$this->eventLogoff();
   		// check, if there are errors in the stack left that are yet to display
		if (!$errorStack->isEmpty()) {
			return $this->eventDisplayError();
		}
		
   		$myContext = &dialogContextWithFrom($this->myContextID,0,0,0);
   		$myContext->invalidate();
		session_unset();
		session_destroy();
   		
   		header('Location: '.$goodbyefile);
		exit;

	}
	

	//---Window Display---------------------------------------------------------
	protected function fillControls($mc) {
		// read hints in the baseclass when modifying this method
		if ($fp = $this->footerPane) {
			$status = $fp->named("status");
			$status->setValue($this->windowStatus());
		}		
	}

  	protected function openBody() {
 		// overwrite this for your window's contents
 		// note: no <body> section here, as $this->pane is a frameset
 		// see function initWindow

		// render the main frameset
 		echo $this->pane->render();
 	}

}
?>