<?PHP

/**
 * Base class for the insert dialogs and copy dialogs.
 * When this window is opened assume
 * 	model[0] is 0
 *  model[1] is an empty array
 *  optional: model[2] a key/value array containing a row of default (or copy) values.
 * Concrete classes must initialize extraAttributesToUpdate with the names of
 * the fields that should be initialized during INSERT of the new db record.
 * These must include at least all NOT NULL fields.
 * 
 * @todo comment, cleanup, version, test
 * @package GGF
 * @version 3.2.2
 * @since 3.2.2
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFControlInsertDialog extends GGFControlDialog {

	protected $extraAttributesToUpdate = array(); // specify here the names of the attributes that - besides auto increment keys - need manual input during an insert transaction

	function __construct($contextID) {
		parent::__construct($contextID);
		$this->ETypeName = "user";
       	//$this->userInfoText = 'Type initial data and click OK to create the new entry.';
       	$this->extraAttributesToUpdate = array(); // specify the attributes that need to be entered
       	// besides the primary key . For instance because they should be unique.
   	}
	
	public function dataPlausible() {
		// if true, OK can be clicked
		return $this->isLoggedOn();
	}

	public function directAccessURL() {
		// create a direct access url.
		// this is used in GGFStandardMenuDialog 
		// but normally does only make sense in update dialogs 
		return ""; 
	}

	/**
	 * create a model object from the array of extraAttributesToUpdate
	 * @see GGFControlWindow::initModel()
	 */
	public function initModel($mc) {
		parent::initModel($mc);
		foreach ($this->extraAttributesToUpdate as $attr) {
			$this->myModel[1][$attr] = '';
		}
	}
	
	protected function extraAttributesToUpdate() {
		return $this->extraAttributesToUpdate;
	}
	
	/**
	 * set extra attributes to update
	 *
	 * @param $extraAttributes array of the attributes that should be set
	 */
	protected function setExtraAttributeToUpdates($extraAttributes) {
		$this->extraAttributesToUpdate = $extraAttributes;
	}
	
	protected function createINSERT() {
		global $db;
		//create the insert statement , with data from controls
		//check input validity here
		
		$sql = "INSERT INTO ".$this->ETypeName." SET ";
		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
   		$pk = $et->primaryKey();
   		
		//$atts = $et->attributeNames();
		$c = "";
		$row = array();
		foreach ($pk as $an) { // this already prepared for composite keys
			$control = $this->pane->named($an);
			if ($control) {
				$att = $et->getAttributeNamed($an);
				$row[$an] = $control->value();
				$sql = $sql.$c." ".$an."=".$att->asSQL($row);
				$c = ", ";
			} 	
		}

		// add extraAttributesToUpdate 
		if (count($this->extraAttributesToUpdate) > 0) {
			foreach($this->extraAttributesToUpdate as $extraAtt) {
				if (array_key_exists($extraAtt, $this->myModel[1])) {
					$sql = $sql.$c." ".$extraAtt."= '".$db->escape_string($this->myModel[1][$extraAtt])."'";
					if ($c=="") {
						$c = ", ";
					}
				}
			}
		}
		
		// in case of copy - insert residual values of myModel[2]
		if (isset($this->myModel[2])) {
			$keys = array_keys($this->myModel[2]);
			foreach ($keys as $key) {
				if (in_array($key, $this->extraAttributesToUpdate)){
					// skip - attribute allready added above via extraattributes
				} else {
					$sql = $sql.$c." ".$key."= '".$db->escape_string($this->myModel[2][$key])."'";
					if ($c=="") {
						$c = ", ";
					}
				}
			}
		}
		
		// moved to getNewPKID()
		/*$this->myModel[0] = $row[$atts[0]]; // remember pk in context for caller, needs adaptation for composite keys
		$mc = &windowContext($this->myContextID,0);
		$mc->model = $this->myModel;
		$mc->save();*/
			 
		return $sql;
	}

	protected function initWindow($mc) {
		parent::initWindow($mc); // has already an empty menu-pane
		// in concrete classes overwrite this method and call parent
		// add controls there
		
		/*$formarea = $this->pane->named("_mainform");
		//$formarea->newP();
		$formarea->add(new GGFStaticfield('', $this->userInfoText));
		$formarea->newLine();*/

		/*$formarea->newRow(new GGFStaticfield("", "User ID:"));
		$ef = new GGFEntryfield("userid", "",    10, $maxlength=16, $tiptext="the userid for login");
		// $ef->setReadonly(); this makes sense for autoincrement keys
		$formarea->newCell($ef);*/
	}		
	
	protected function fillControls($mc) {
		parent::fillControls($mc);

		if (isset($this->myModel[2])) {
			// take myModel[2] and fill same-named controls with its data
			$itr = $this->pane->paneIterator();
			$c = $itr->next();
			while (!$c == 0) {
				if ($c->isEntry()) {
					if (isset($this->myModel[2][$c->name()])) {
						//echo "<br>set value of ",$c->name();
						$c->setValue($this->myModel[2][$c->name()]);
					}
				} else if ($c->isSingleSelection() && isset($this->myModel[2][$c->name()])) {
					$c->setSelection(array($this->myModel[2][$c->name()]));
				}
				$c = $itr->next();
			}
		}
	}
	
	protected function readControls($mc) {
		global $errorStack;
		parent::readControls($mc);
		/*
		// in case of copy - insert residual values of myModel[2]
		if (isset($this->myModel[2])) {
		
			// myModel[2] is used for copy operations
			foreach($this->myModel[2] as $key => $value) {
				// $errorStack->pushMsg(print_r($key, TRUE));
				if (!($this->pane->named($key)==0)) {
					$c = $this->pane->named($key);
					if (!$c->isReadonly()) {
						if ($c->isEntry()) {
							//$errorStack->pushMsg($key."=".$this->pane->named($key)->value());
							$this->myModel[1][$key] = $this->pane->named($key)->value();
						} else if ($c->isSingleSelection()) {
							$this->myModel[1][$key] = $this->pane->named($key)->getSelection();
							$this->myModel[1][$key] = $this->myModel[1][$key][0];
						}
					}
				}
			}
		}
		*/
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	//---events------------------------------------------------------
	
	/**
	 * remembers pk value in context for caller
	 */
	protected function getNewPKID() {
		global $db;
		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
		$pk = $et->primaryKey();
		$pkValues = array();
		
		if (count($pk) <= 1) {
			// only one primary key attribute - pk value is autoincrement in db
			$this->myModel[0] = $db->lastInsertID();
		} else {
			// more than one pk attributes
			foreach ($pk as $an) { // this already prepared for composite keys
				$control = $this->pane->named($an);
				if ($control) {
					array_push($pkValues, $control->value()) ;
				} 	
			}
	
			// add extraAttributesToUpdate 
			/*foreach($this->extraAttributesToUpdate as $extraAtt) {
				if (array_key_exists($extraAtt, $this->myModel[1])) {
					array_push($pkValues, $this->myModel[1][$extraAtt]);
				}
			}*/
			
			$this->myModel[0] = implode(',', $pkValues);
		}
		$mc = &windowContext($this->myContextID, 0);
		// clean up model before calling update dialog
		if (isset($this->myModel[1])) {
			unset($this->myModel[1]);
		}
		if (isset($this->myModel[2])) {
			unset($this->myModel[2]);
		}
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	protected function validateData() {
		return true;
	}
	
	/*
	protected function eventOK() {
		// here we want to come wenn the OK-button is clicked
		
		global $db;
		global $errorStack;
		
		if ($this->validateData()) {

			// Begin a db transaction
			// Note: MySQL would not need a transaction for a single insert, but others like DB2 will need it
			$db->beginTransaction();		
	
			$sql = $this->createINSERT();
			// insert empty record into db
			$db->execSQL($sql, $this->ETypeName);
			if (!$db->OK()) {
				$errorStack->pushUsrMsg(1,"Cannot insert the new ".$this->ETypeName."-record");	
				$db->cancelTransaction();
			} else {
				$this->getNewPKID();	// remember pk in context for caller
				$db->endTransaction();
				if ($db->OK()) {
					$this->ok = TRUE;
					$this->eventClose();	
				}
			}
		}
	}
	*/
	
	protected function eventOK() {
		// handles OK event
		$this->saveInserts();
		if ($this->ok) {
			$this->eventClose();
		}
	}
	
	//---open---------------

	protected function openHeadTitle() {
		global $appname;
		if ($this->windowTitle>"") {
			echo "<title>".$this->windowTitle." </title>";
		} else {
			if ($this->ETypeName>"") {
				echo "<title>".$this->ETypeName."-insert - ".$appname."</title>";
			} else {
				echo "<title>Insert - ".$appname."</title>";
			}
		}	
	}

	protected function saveInserts() {
		global $db;
		global $errorStack;
		
		// verification of data before Update. If verification fails a message is posted in $errorStack
		if ($this->validateData()) {
			
			// Begin a db transaction
			// Note: MySQL would not need a transaction for a single insert, but others like DB2 will need it
			$db->beginTransaction();		
	
			$sql = $this->createINSERT();
			// insert empty record into db
			$db->execSQL($sql, $this->ETypeName);
			if (!$db->OK()) {
				$errorStack->pushUsrMsg(1,"Cannot insert the new ".$this->ETypeName."-record");	
				$db->cancelTransaction();
			} else {
				$this->getNewPKID();	// remember pk in context for caller
				$db->endTransaction();
				if ($db->OK()) {
					$this->ok = TRUE;
				}
			}
			
		}
	}
}
?>