<?PHP

/**
 * GGF base functions for session handling and initialization
 * Add: 
 * $GGFPath = "GGF/"; 		// relative path to framework classes
 * require $GGFPath."GGF.php";
 * 
 * at the beginning of the start script of your application
 * 
 * @todo 
 * @package GGF
 * @version 4.0
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2006, 2011 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
// programming hints: 
// callstack: debug_print_backtrace();
// values:    error_log_adv(print_r(anobject,TRUE))
// Top error types:
// missing () in function call
// missing $this in instance variable access
// missing global
// upper-lowercase in variables

global $errorStack;
global $db;
global $ERModel;


global $faviconURL;
global $GGFPath;
require $GGFPath.'GGFSetup.php';
require $GGFPath.'GGFControls.php';

session_start();

//function __autoload($class_name) {
//    require_once $class_name . '.php';
//}
function __autoload($className) { 
	
	global $GGFPath;
	global $appPath;

    if (file_exists($GGFPath.$className.'.php')) { 
        require_once $GGFPath.$className . '.php'; 
        return true; 
    } elseif(file_exists($appPath.$className.'.php')) {
		require_once $appPath.$className . '.php'; 
        return true; 
    } else {
		echo $GGFPath.$className.".php not found and<br>
".$appPath.$className.".php not found";
		exit;
	}
} 


/**
 * Logs an error message together with the userid
 * @param string $error 
 */
function error_log_adv($error) {
	error_log($_SESSION['userid'].' ] '.$error);
}

if (!isset($_SESSION["_errorStack"])) {
   	$_SESSION["_errorStack"]=new GGFErrorStack();
}

//GGF3.2
$errorStack = $_SESSION["_errorStack"];

$db = new GGFDatabase($dbhost,$dbuser,$dbpw,$dbname,$appname);

if (!isset($_SESSION["_ERModel"])) {
	$modelclass = $appname.'Model';
	if (class_exists($modelclass)) { 
		$_SESSION["_ERModel"] = new $modelclass(); // this describes the ER-Model of the application
	} else {
		exit("<br>
GGF.php: Model class '".$modelclass."' not found. Check value of \$appname in GGFSetup.php. ");
	}
}
$ERModel = $_SESSION["_ERModel"];
/**
 * get a window context object
 * 
 * @param integer $cid
 * @param string $className
 * @return array 
 */	   
function &windowContext($cid, $className) {
	// the context is an array in the session, if cid (contextID) is 0, a new context is created
	// parent's ContextID) is set to 0
	$model = array();
	$c = &dialogContextWithFrom($cid, $model, 0, $className);
	return $c;  
	
}
/**
 *
 * The context is an array in the session, if cid (contextID) is 0, a new context is created
 * if cid and pcid (parent's ContextID) are 0 a new context-root (for href with target=_blank for instance is create)
 *
 * @param integer $cid numer of context or 0 to get a new one
 * @param type $model model object for the context
 * @param integer $pcid parent context id or 0 if its a root context
 * @param string $className name of window or dialog class
 * @return \GGFContext 
 */
function &dialogContextWithFrom($cid, $model, $pcid, $className) {
	if ($cid == 0) { 
	   // new context
	   if (!isset($_SESSION["_lastcid"])) {
	   	// new session
	   	$_SESSION["_lastcid"]=0;
	   	$_SESSION["_cstack"]= array("_dummy"=>(new GGFContext(0,0,0,0)));
	   }
	   //$newcid = $_SESSION["_lastcid"] + 1;
	   $newcid = mt_rand(100100000,2000000000);
	   $_SESSION["_lastcid"] = $newcid;
	   $cs = $_SESSION["_cstack"];
	   $c = new GGFContext($newcid, $pcid, $model, $className); 
	   $cs[$newcid] = $c;
	   $_SESSION["_cstack"] = $cs;
	   return $cs[$newcid]; // return the new context-object
	} else {
	   $cs = $_SESSION["_cstack"];
	   return $cs[$cid];
	}
}

/**
 * reset all session context 
 */
function invalidateContextStack() {
	if (isset($_SESSION["_cstack"])) { // context stack already exists
		$cs = $_SESSION["_cstack"];
		foreach ($cs as $c) {
			$c->invalidate();
			// invalid sub-contexts
			foreach ($cs as $sc) {
				if ($sc->parentContextID == $c) {
					$sc->invalidate();
				}
			}
		}
		$_SESSION["_cstack"] = $cs;
	}
}

/**
 * 
 * Display a message box dialog and return o the current window or dialog
 * @param int $ci provide $this->myContextID
 * @param string $msg the message shown
 * @param int $nrButtons optional, 1: OK (default) , 2: Yes/No, 3: Yes/No/Cancel
 * If nrButtons is 2 or 3 you need to specify the returnCallback function. 
 * @param string $returnCallback name of a function in the current window hat will process the answer of the user
 * @param boolean $htmlMessage If set to true, HTML tags in $msg will not be shown, but interpreted
 */	
function messageBox ($ci, $msg, $nrButtons=1, $returnCallback="",$htmlMessage=FALSE) {
		$myContext = &windowContext($ci,0);
		$myContext->openDialogOn("GGFControlMessageBox", 
		array($msg, $nrButtons,$htmlMessage), 
		$returnCallback);
}

/**
 * 
 * Display a prompter dialog that allows entering a simple string
 * In the returnCallback method evaluate:
 * $subContext->model[1] = the text input
 * $subContext->result = TRUE (OK clicked) or FALSE (Cancel clicked)
 *  
 * @param int $ci provide $this->myContextID
 * @param string $msg the prompting message/question
 * @param string $returnCallback name of a function in the current window hat will process the answer of the user
 * @param string $value opional,default ="" preset value of the answer
 * @param int $nrButtons optional,default = 2 (OK/Cancel), 1 means OK only
 * @param string $title optional Headline of the prompter
 */
function messagePrompter ($ci, $msg,  $returnCallback, $value="", $nrButtons=2, $title="Value Entry") {
		$myContext = &windowContext($ci,0);
		$myContext->openDialogOn("GGFMessagePrompter", 
		array($msg, $value, $nrButtons, $title), 
		$returnCallback);
}
/**
 * Open a Messagebox to select a value from a list of options
 * The return callback function can evaluate the result:
 * 		if ($subContext->result) { // OK clicked
 *   		$selectedOption = $subContext->model[0][0]; 
 *	   	}
 *
 * @param integer $ci the id of the context of the calling window
 * @param array $options 
 * @param string $returnCallback
 * @param string $title
 * @param string $preselection 
 */
function lookupBox($ci, $options,$returnCallback,$title="Select from List", $preselection=array(0)) {
		$myContext = &windowContext($ci,0);
		$myContext->openDialogOn("GGFControlLookupDialog", 
		array($preselection,$options,$title), 
		$returnCallback);
}

function mailErrorHandler($errno, $errmsg, $filename, $linenum, $vars) {
	global $errorStack;
	$errorStack->pushMsg($errmsg);
	if ($errno != E_WARNING || substr($errmsg, 0, 6) != 'mail()') {
		$errorStack->pushMsg('Unexpected error.Location:'.$filename.' line:'.$linenum);		
	} else {
		$errcode = substr($errmsg, (stripos($errmsg, 'response: ') + 10), 3);
		if ($errcode > 0) {
			if ($errcode == 550) {
				$errorStack->pushMsg('E-Mail Could not be sent: One or more recipients were not allowed.Location:'.$filename.' line:'.$linenum);
			} else if ($errcode == 553) {
				$errorStack->pushMsg('E-Mail Could not be sent: Recipients contain invalid addresses/text.Location:'.$filename.' line:'.$linenum);
			}
		}
		$errorStack->pushUsrMsg('E-Mail Could not be sent.');
	}
}
?>