<?PHP
/**
 * Dialog to select and save Queries
 * For GGF internal use.
 *
 * assume  model[0] = GGFQuery
 * model[1] = a query name
 * model[2] = all stored queries
 *
 * @package GGF
 * @version 4.0
 * @since 3.3
 * @author Gerald Zincke, Austria
 * @copyright 2006, 2012 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFQuerySelectDialog extends GGFControlDialog {

	/** @var GGFStaticfield a control to display error messages */
	protected $bugfield;
	
	function __construct($contextID) {
		$this->bugfield = new GGFStaticfield("bugfield", "."); // instantiate it here that it can be accessed even before initWindow
		parent::__construct($contextID);
		$this->ETypeName = 'GGFQuery';
		//echo("bugfield:".print_r($this->bugfield,TRUE));
		//exit;
	}
	
	protected function createSELECT() {
   		// the select statement to read the updated query
   		$row = $this->myModel[0]->row();
   		return "SELECT * FROM ".$this->ETypeName.
   		" WHERE qname='".$row["qname"]."'";
	}

	protected function createSELECT2() {
   		// the select statement to read the query-list
   		return "SELECT * FROM ".$this->ETypeName." WHERE ETypeName='".$this->myModel[0]->etypename()."'";
	}


	protected function initWindow($mc) {
		parent::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Select an existing query or save current view as new query."));
		$formarea->newLine();
		$formarea->newCell(new GGFListbox("queries", array(), array(), 
					$hsize=600, $vsize= 10, 
					$tiptext="List of available queries", 
					$extraHTML = "", FALSE));

		$buttonColumn = new GGFControlPane($this,"buttonColumn");
		$buttonColumn->newRow(new GGFPushbutton("explain",   "explain Query",
		    "eventExplain",  $validator="", $size=100, $tiptext="describes describung text about the query", $extraHTML=""));
		$buttonColumn->closeTable();
		$formarea->newCell($buttonColumn);
		$formarea->closeTable();
		$formarea->newLine();
		
		$buttonarea = $this->pane->named("_buttonarea");
		$buttonarea->clearControls(); // remove inherited button-definitions
		$buttonarea->add(new GGFPushbutton("select",    "select Query",    "eventSelect",    $validator="", $size=120, $tiptext="selects the query and closes the dialog", $extraHTML=""));
		$buttonarea->newSpace(2);
		$buttonarea->add(new GGFPushbutton("_Cancel", "Cancel", "eventClose", "", 80, "do not save data in database"));
		$buttonarea->newSpace(2);
		if($this->isLoggedOn()) {
			$buttonarea->add(new GGFPseudoPushbutton("mq", " Manage Queries ", "eventManageQueries", $validator="", $size=0, 
					$tiptext="delete and update queries", 
					$extraHTML="", $target="_blank"));
		}
		$buttonarea->newLine();

		$buttonarea->add($this->bugfield); //note this has to be after the OK button, because it is set by its validator
	}
	
	protected function readControls($mc) {
		
		//GGF3.2.1
		//$qn = $this->pane->named("qname")->value();
		//$this->myModel[0]->setQname($qn);
		
		$sel = $this->pane->named("queries")->getSelection();
		$this->myModel[1] = $sel[0];
						
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	protected function fillControls($mc) {
		$ql = array();
		$kl = array();
		
		if (isset($this->myModel[2])) {
			foreach ($this->myModel[2] as $query) {
				//print_r($query);
				array_push($ql,substr($query->owner().':           ',0,12).$query->qname());
				array_push($kl,$query->qname());
			}
		}
		$selections = array();
		if (isset($this->myModel[1])) {
			$selections = array($this->myModel[1]);
		} else {
			if (isset($kl[0])) {
				$selections = array($kl[0]);
				$this->myModel[1] = $kl[0];
			}
		}
		$this->pane->named("queries")->setSelection($selections);
		$this->pane->named("queries")->setValue($ql);
		$this->pane->named("queries")->setKey($kl);
	}

	

	//---callbacks--------------------------
	
	protected function eventSelect() { // select an existing query
		global $db, $errorStack;
 		$mc = &windowContext($this->myContextID,0);
 		
		foreach ($this->myModel[2] as $query) {
			if($query->qname() == $this->myModel[1]) {
				if ($query->isValid()) {
					$this->myModel[0] = $query;	
					$mc->model = $this->myModel;
					$mc->save();
					$this->ok = TRUE;
					$this->eventClose();	
					exit;
				} else {
					$et = $this->ERModel->entityTypeNamed($query->etypename());
					$db->execSQL($et->createSelect($query->columns(), $query->filter(), $query->sorter()));
					if ($errorStack->isEmpty()) {
						$row = $query->row();
						$row['thechecksum'] = serialize($et);
						$query->setRow($row);
						$this->myModel[0] = $query;	
						$mc->model = $this->myModel;
						$mc->save();
						$this->ok = TRUE;
						$errorStack->pushUsrMsg(1,"This query has been changed, because the model '".$query->etypename()."' has changed. If everything works correctly, save the query again.");
						$this->eventClose();	
						exit;
					} else {
						messageBox($this->myContextID,
							"This query is not valid anymore, because the model '".$query->etypename()."' has changed."
							,
							1,
							"");
						exit;
					}
				}
			}
		}
		// selected query not found
		$errorStack->pushUsrMsg(1,"GGFQuerySelectDialog: selected query not found");
	}

	protected function eventExplain() { // explain the properties of an existing query
		global $errorStack;
 		$mc = &windowContext($this->myContextID,0);
 		
		foreach ($this->myModel[2] as $query) {
			if($query->qname() == $this->myModel[1]) {
				$this->myModel[0] = $query;	
				$mc->model = $this->myModel;
				$mc->save();
				$f = $query->filter();
				messageBox($this->myContextID,
				'Query "<b>'.$query->qname().'</b>" defines the following:<br>'.
				"Owner: <b>".$query->owner()."</b><br>".
				"Columns: <b>".implode(", ",$query->columns())."</b><br>".
				"Filter: <b>".$query->filter()->asSQL()."</b> - selects ".$f->count()." rows.<br>".
				"Sorter: <b>".$query->sorter()->orderBy()."</b>"
				,
				1,
				"",
				TRUE);
				exit;
				
			}
		}
		// selected query not found
		$errorStack->pushUsrMsg(1,"GGFQuerySelectDialog: selected query not found");
	}
	
	
	protected function eventManageQueries() {
		// manage all available queries
		
		$myContext = &windowContext(0,0);
		$myContext->openWindowOn("GGFQueryBrowserWindow", array() );
		
   	}

	
	//---open---------------
   		
	protected function initModel($mc) {
   		// prepare the model object
   		
   		global $db;
		global $errorStack;
		global $traceLevel;
		$this->myModel = $mc->model;
		
		// the database record has not yet been read for this context
		$res = $db->execSQL($this->createSELECT2());
	
		if (!$db->OK()) {
			$errorStack->pushMsg(__File__."->initModel: Cannot read table.");
			// not necessary to display error here, done in open
	   		$this->myModel = $mc->model;
		} else {
			$this->myModel[2] = array();
			while($row = $db->fetchRow($res)) {
				$q = new GGFQuery(); $q->setRow($row);
				array_push($this->myModel[2], $q);
			}
			if ($traceLevel>=2) { 
				error_log_adv ("$this->appname ".__CLASS__."->".__FUNCTION__.": ".
				count($this->myModel["_list"]).' records written to $this->myModel["_list"]');
			}
			$mc->model = $this->myModel;
			$mc->save();
		}
   		
	}

	protected function openHeadTitle() {
		echo "<title>Select query</title>";
	}

}
?>