<?PHP
/**
 * GGF error stack. This class implements a global storage for error
 * messages. Error messages can be pushed on the stack by any function
 * The framework will take care that error messages are displayed and 
 * that data are not saved, if errors occurred.
 * 
 * @todo 
 * @package GGF
 * @version 4.0
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2005, 2011 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFErrorStack {

	protected $es; 	// stack
	protected $esp;	// stack pointer
	
	function __construct() {
		$this->esp = 0;
		$this->es  = array();
	}
	function isEmpty() {
		return ($this->esp == 0);
	}
   	protected function save() {
	   	$_SESSION["_errorStack"] = $this;	   
   	}

	/*
	 * Push a system message to the errorstack.
	 * System messages will be written to the log, but will not be displayed to the user
	 */
   	public function pushMsg($txt) {
		return $this->pushUsrMsg(0,$txt);
	}
	
	/*
	 * Push a message to the errorstack
	 * If $usr == 1 a user messages will be pushed. User messages are displayed to the user
	 * else a system message will be written to the log, but will not be displayed to the user
	 * Depending on trace level, error  messages will be written to error log
	 * @param integer $usr
	 * @param string $txt
	 */
	public function pushUsrMsg($usr,$txt) {
		global $traceLevel;
		if ($usr==1) {
			$msg = "usr".$txt;
		} else {
			$msg = "sys".$txt;
		}
		$this->esp++;
		if ($traceLevel>=1) { error_log_adv ('GGFErrorStack->pushMsg: '.$msg);};
		if ($traceLevel>=2) { 
			$trace = "";
			$calls = debug_backtrace();
			foreach($calls as $c) {
				$trace = $trace. " -from ".$c["file"].":".$c["function"].":".$c["line"];
			}
			error_log_adv ($trace);
		}
		$this->es[$this->esp] = $msg;
		$this->save();
	}
	/**
	 * 
	 * Return the contents and make it empty.
	 * @return array - of strings
	 */
	public function popAll() {
		$result = $this->es;
		$this->esp = 0;
		$this->es = array();
		$this->save();	
		return $result;
	}
	
}