#
# execute this sql script to initialize a database for the GGFDemo application
# If you want to change the database name (see first two statements) then you must
# also change the name in GGFSetup.php.
#
# The script is valid for MySQL 5.x . 
# If you want to use GGF with other databases it may need adaptations.
# See also GGFDatabase.php in this case
#
# @author Gerald Zincke, Austria
# @copyright 2005,2012 Gerald Zincke
# @license http://www.reinhtml.eu/ggf/license.htm#top
#
create database GGF;

use GGF;


DROP TABLE IF EXISTS user;

CREATE TABLE `user` (
  `userid` 			varchar(16) NOT NULL,
  `password_enc` 	varchar(32) NOT NULL,
  `lastname` 		varchar(32) ,
  `firstname` 		varchar(32),
  `preferences`		text DEFAULT NULL,
  `email` 			varchar(255),
  `LastChange` 		timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,  
PRIMARY KEY (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `user` SET userid=test, password_enc=MD5(test);
INSERT INTO `user` SET userid=demo, password_enc=MD5(demo);

select userid, password_enc, lastchange from user;

DROP TABLE IF EXISTS GGFQuery;

CREATE TABLE GGFQuery
(
	id			integer AUTO_INCREMENT,
	owner  		VARCHAR(16) NOT NULL,
	ETypeName  	VARCHAR(64) NOT NULL,
	browser	    VARCHAR(64) NOT NULL,
	qname		VARCHAR(128) NOT NULL,
	filter  	TEXT,
	sorter		TEXT,
	thecolumns	TEXT,
	columnsize	TEXT,
	thechecksum	TEXT,
	PRIMARY KEY (id)
) ENGINE = InnoDB;

# optional tables

DROP TABLE IF EXISTS GGFNote;

CREATE TABLE GGFNote
(	
	id				integer AUTO_INCREMENT,
	last_change 	TIMESTAMP,
	userid			VARCHAR(16) NOT NULL,
	ispublic        BOOL,
	objectkey       VARCHAR(64),
	windowclassname VARCHAR(64) NOT NULL,
	controlname		VARCHAR(64),
	note			TEXT,
	PRIMARY KEY (id)
)ENGINE = InnoDB;

# no load necessary

DROP TABLE IF EXISTS GGFHistory;

CREATE TABLE GGFHistory
(
	id				integer AUTO_INCREMENT,
	last_change 	TIMESTAMP,
	userid			VARCHAR(16) NOT NULL,
	userip			VARCHAR(16) NOT NULL,
	tablename		VARCHAR(64) NOT NULL,
	historydata		TEXT,
	PRIMARY KEY (id)
)ENGINE = InnoDB;

# no load necessary
