<?PHP

/**
 * Class to provide order by clause of a select statement
 * 
 * @todo comment, test
 * @package GGF
 * @version 2.2
 * @since 1.0
 * @author Gerald Zincke, Austria
 * @copyright 2005 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFSqlSorter {
	// GGF (c) 2005 - Gerald Zincke, Austria	
	// dummy implementation, to be extended
	protected $order;
	protected $criteria;

	function __construct($criteria = array()) {
		$this->order = '';
		$this->criteria = $criteria;
	}
	
	public function setOrderClause($sql) {
		$this->order = $sql;
	}
	
	public function setCriteria($arr) {
		$this->order = "";
		$this->criteria = $arr;
		foreach($arr as $crit) {
			if ($this->order == "") {
				$this->order = $crit;
			} else {
				if (!($crit == "")) {
					// print_r($this);
					$this->order = $this->order.', '.$crit;
				}
			}
		}
	}
	
	public function getCriteria() {
		return $this->criteria;
	}
	
	public function orderBy() {
		if (count($this->criteria)>0 ) {
			$this->order = "";
			foreach($this->criteria as $crit) {
				if ($this->order == "") {
					$this->order = $crit;
				} else {
					$this->order = $this->order.', '.$crit;
				}
			}
			return "ORDER BY ".$this->order;
		} else {
			if ($this->order == '') {
				return '';
			} else {
				return 'ORDER BY '.$this->order;
			}
		}
	}
}
?>