<?PHP
/**
 * Implementation of a field comparison
 *
 * This fits for both GGFERFilter and GGFSqlFilter
 * 
 * @todo comment, test
 * @package GGF
 * @version 3.0
 * @since 2.3
 * @author Gerald Zincke, Austria
 * @copyright 2005 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFSqlFilterClause {
	// use this for numeric fields and values that do not need enclosed in '' in SQL
	protected $clauseOperator;
	protected $field;
	protected $comparisonOperator;
	protected $value; 
	protected $isText; 
	
	function __construct($andor, $fi, $op, $val, $isText=TRUE) {
		$this->clauseOperator = $andor;
		$this->field = $fi;
		$this->comparisonOperator = $op;
		$this->value = $val;
		$this->isText = $isText;
	}
	
	public function clauseOperator() {
		return $this->clauseOperator;
	}
	
	public function field() {
		return $this->field;
	}
	
	public function comparisonOperator() {
		return $this->comparisonOperator;
	}

	public function value() {
		return $this->value;
	}

	public function matches($aRow) {
		global $errorStack;

		if ($this->comparisonOperator == '=') {
			return $aRow[$this->field] == $this->value;
		} elseif ($this->comparisonOperator == '>') {
			return $aRow[$this->field] > $this->value;
		} elseif ($this->comparisonOperator == '<') {
			return $aRow[$this->field] < $this->value;
		} elseif ($this->comparisonOperator == '<=') {
			return $aRow[$this->field] <= $this->value;
		} elseif ($this->comparisonOperator == '>=') {
			return $aRow[$this->field] >= $this->value;
		} elseif ($this->comparisonOperator == '<>') {
			return !($aRow[$this->field] == $this->value);
		} elseif ($this->comparisonOperator == 'IS NULL') {
			return $aRow[$this->field] = 0;
		} elseif ($this->comparisonOperator == 'LIKE') {
			$errorStack->pushUsrMsg(1,'operator LIKE is not supported for internal matches');
		}
	}
	
	protected function valueAsSQL() {
		global $db;
		if ($this->isText) {
		   	return "'".$db->escape_string($this->value)."'";
		} else {
			return $this->value;
		}
	}
	
	public function asSQL() {
		if ($this->comparisonOperator == 'IS NULL') {
			return $this->field.' '.$this->comparisonOperator;
		} else if ($this->comparisonOperator == 'NOT NULL') {
			return $this->field.' IS NOT NULL';
		} else {
			return $this->field.' '.$this->comparisonOperator.' '.$this->valueAsSQL();
		}
	}
}
?>