<?PHP
/**
 * Dialog to save Queries
 * For GGF internal use.
 *
 * assume  model[0] = GGFQuery
 * model[1] = selection
 * model[2] = all stored queries
 *
 * @todo comment, cleanup, version, test
 * @package GGF
 * @version 3.3
 * @since 3.3
 * @author Gerald Zincke, Austria
 * @copyright 2006 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFQuerySaveDialog extends GGFQuerySelectDialog {

	/** @var GGFStaticfield a control to display error messages */
	protected $bugfield;
	
	protected function initWindow($mc) {
		GGFControlDialog::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "Select an existing query or save current view as new query."));
		$formarea->newLine();
		$formarea->newCell(new GGFListbox("queries", array(), array(), 
					$hsize=600, $vsize= 10, 
					$tiptext="List of available queries", 
					$extraHTML = "", FALSE));

		$buttonColumn = new GGFControlPane($this,"buttonColumn");
		$buttonColumn->newRow(new GGFPushbutton("explain",   "explain Query",    "eventExplain",  $validator="", $size=180, $tiptext="describes describung text about the query", $extraHTML=""));
		$buttonColumn->closeTable();
		$formarea->newCell($buttonColumn);
		$formarea->closeTable();
		$formarea->newLine();
		$formarea->add(new GGFStaticfield("", "Save current Query as:"));
		$formarea->newLine();
		$formarea->add(new GGFEntryfield("qname", "",  64, 64, "name/title of query"));
		
		$buttonarea = $this->pane->named("_buttonarea");
		$buttonarea->newSpace(2);
		$buttonarea->add(new GGFStaticHyperlinkfield("manageQueries",$this->callbackURL("eventManageQueries"),"Manage Queries", 0, 
					$tiptext="update table list", 
					$extraHTML=' class="GGFmenu" target="_blank"'));
		$buttonarea->newLine();

		$buttonarea->add($this->bugfield); //note this has to be after the OK button, because it is set by its validator
	}
	
	protected function readControls($mc) {
		
		//GGF3.2.1
		$qn = $this->pane->named("qname")->value();
		$this->myModel[0]->setQname($qn);
		
		$sel = $this->pane->named("queries")->getSelection();
		$this->myModel[1] = $sel[0];
						
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	protected function fillControls($mc) {
		//print_r($this->myModel);
		
		$this->pane->named("qname")->setValue($this->myModel[0]->qname());
		
		$ql = array();
		foreach ($this->myModel[2] as $query) {
			//print_r($query);
			array_push($ql,$query->qname());
		}
				
		if (isset($this->myModel[1])) {
			$selections = array($this->myModel[1]);				
		} else {
			$selections = array($ql[0]);
		}
		$this->pane->named("queries")->setSelection($selections);
		$this->pane->named("queries")->setValue($ql);
		//$this->dataPlausible();
		parent::fillControls($mc);		
	}

	

	//---callbacks--------------------------
	
	
	protected function eventOK() { // save new query
		global $db;
		global $errorStack;
		
		
   		$et = $this->ERModel->entityTypeNamed($this->ETypeName);
		
 		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
		// Begin a db transaction
		$db->beginTransaction();		
		// read row again
		$res = $db->execSQL($this->createSELECT());
		//print_r($this->createSELECT());
		if ($db->OK()) {
			$row = $db->fetchRow($res);
			if ($row == "") {
				//echo "nothing read";
			} else {
				$newrow = $this->myModel[0]->row();
				if ($row["owner"] == $newrow["owner"]) { // ok to update
				
					$newrow["id"] = $row["id"];
				
					$sql = $et->createUpdate($newrow);
					//print_r($sql);
					$res = $db->execSQL($sql,$this->ETypeName);
					if (!$db->OK()) {
						$errorStack->pushMsg("GGFQuerySaveDialog: Cannot update query");
						$db->cancelTransaction();
					} else {
						$db->endTransaction();
						if ($db->OK()) {
							$this->myModel[0]->setRow($newrow);
							$mc->model = $this->myModel;
							$mc->save();
							$this->ok = TRUE;
							$this->eventClose();	
						}
					}					
					return;
				} else {
				 	messageBox($this->myContextID,
					'Cannot update a Query of '.
					"owner: <b>".$row["owner"]."</b><br>"
					,
					1,
					"");
				}
			}
		}
		// probably query not found, try insert
		$db->cancelTransaction();
		$errorStack->popAll(); // ignore above
			
		$sql = $et->createInsert($this->myModel[0]->row());
	
			
		$db->beginTransaction();		
		
		$res = $db->execSQL($sql,$this->ETypeName);
		
		if (!$db->OK()) {
			$errorStack->pushUsrMsg(1,"GGFQuerySaveDialog: Cannot insert new query");
			$db->cancelTransaction();
		} else {
			$id = $db->lastInsertID();
		
			$r = $this->myModel[0]->row();
			$db->endTransaction();
			if ($db->OK()) {
				$r["id"] = $id;
				$this->myModel[0]->setRow($r);
				$mc->model = $this->myModel;
				$mc->save();
				$this->ok = TRUE;
				$this->eventClose();	
			}
		}					
		return;
			
	}
	
	protected function eventManageQueries() {
		// manage all available queries
		
		$myContext = &windowContext(0,0);
		// print_r($subContext);
		//$mod = $this->myModel[0]; // the id of the room
		//print_r($mod);
		$myContext->openWindowOn("GGFQueryBrowserWindow", /*array($mod)*/ array() );
		
   	}

	
	//---open---------------
   		
	
	protected function openHeadTitle() {
		echo "<title>Save query</title>";
	}
		

}
?>