<?PHP

/**
 * This is intended for the update dialog for the Notes menu in the systemtray
 * It requires a table GGFNotes in the database. See GGF.sql. 
 * For GGF internal use.
 * 
 * @package GGF
 * @version 3.1
 * @since 3.0
 * @author Gerald Zincke, Austria
 * @copyright 2005 Gerald Zincke
 * @license http://www.reinhtml.eu/ggf/license.html#top
 */
class GGFNotesDialog extends GGFControlDialog {
	// model[0] contains the name of the windowclass
	// model[1] the name/id of the user
	// model[2] string for primary key of object currently displayed in window
	// model[3] the list of the private and public notes to the object and the window
	
	protected function initWindow($mc) {
		$this->myContainerClass ="GGFNotePane";
		parent::initWindow($mc);
		//print_r($this->pane);
		$formarea = $this->pane->named("_mainform");
		$formarea->newP();
		$formarea->add(new GGFStaticfield("", "You may scroll through notes and add some."));
		$formarea->newLine();
		if (!$this->myModel[2] == "") {
			$formarea->newRow(new GGFStaticfield("", " "));
			$formarea->newCell(new GGFStaticfield("objecttitle", "Notes for current object:"));
			$formarea->newRow(new GGFStaticfield("", "my Notes:"));
			$myNotes = new GGFMultilineEntryfield("myNotes", 
				"", 100, 4, $maxlength=0, 
				$tiptext="type here your notes", $extraHTML="");
			if ($this->isLoggedOff()) $myNotes->setReadonly();
			$formarea->newCell($myNotes);
			$formarea->newCell(new GGFPushbutton("PublishOnotes", "Publish", "eventPublishOnotes", "isLoggedon", 80, "move your notes to the public area"));
			$formarea->newRow(new GGFStaticfield("", "other:"));
			$other = new GGFMultilineEntryfield("otherNotes", 
				"", 100, 4, $maxlength=0, 
				$tiptext="read here other user's notes", $extraHTML="");
			$other->setReadonly();
			$formarea->newCell($other);
			$formarea->newCell(new GGFPushbutton("HideOnotes", "Hide", "eventHideOnotes", "isLoggedon", 80, "move your notes to the private area"));
			$wvsize = 4;
		} else {
			$wvsize = 8;
		}
		$formarea->newRow(new GGFStaticfield("", " "));
		$formarea->newCell(new GGFStaticfield("", "Notes for window ".$this->myModel[0].":"));
		$formarea->newRow(new GGFStaticfield("", "my Notes:"));
		$myWindowNotes = new GGFMultilineEntryfield("myWindowNotes", 
			"", 100, $wvsize, $maxlength=0, 
			$tiptext="type here your notes", $extraHTML="");
		if ($this->isLoggedOff()) $myWindowNotes->setReadonly();	
		$formarea->newCell($myWindowNotes);
		$formarea->newCell(new GGFPushbutton("PublishWnotes", "Publish", "eventPublishWnotes", "isLoggedon", 80, "move your notes to the public area"));
		$formarea->newRow(new GGFStaticfield("", "other:"));
		$other = new GGFMultilineEntryfield("otherWindowNotes", 
			"", 100, $wvsize, $maxlength=0, 
			$tiptext="read here other user's notes", $extraHTML="");
		$other->setReadonly();
		$formarea->newCell($other);
		$formarea->newCell(new GGFPushbutton("HideWnotes", "Hide", "eventHideWnotes", "isLoggedon", 80, "move your notes to the private area"));
		
		$formarea->closeTable();
		$formarea->newLine();
	}



	protected function initModel($mc) {

		parent::initModel($mc);
		// read rows, store in model
		global $db;
		global $errorStack;
   		if (isset($this->myModel[3]) AND (!$this->myModel[3] == 0)) {
			// do not read every time from db, because changes via subdialogs (see eventSelectLevel) would not work
		} else {
			// the database records have not yet been read for this context
			$this->myModel[3] = array();
				
			$res = $db->execSQL($this->createSELECT($mc));		
			if (!$db->OK()) {
				$errorStack->pushMsg("GGFNotesDialog: Cannot read the notes for the window.");
				// not necessary to display error here, done in open
			} else {
				while($row = $db->fetchRow($res)) {
					array_push($this->myModel[3], $row);
				}
			}
			$this->myModel["_preimage"] = $this->myModel[3];
			$mc->model = $this->myModel;
			$mc->save();			
		}
		
	}
		
	protected function modelFor($public, $object) {
	        foreach($this->myModel[3] as $index => $row) {
			if ($object) {
        			if ((!$row["note"]=="") and ($row["ispublic"]==$public) and (!$row["objectkey"]==""))	{
        				return $row;
	       			} 	  
	       		} else {
        			if ((!$row["note"]=="") and ($row["ispublic"]==$public) and ($row["objectkey"]==""))	{
        				return $row;
	       			} 	  
	       		}
        	}   
        	return 0;              
	} 
	protected function indexFor($public, $object) {
	        foreach($this->myModel[3] as $index => $row) {
			if ($object) {
        			if ((!$row["note"]=="") and ($row["ispublic"]==$public) and (!$row["objectkey"]==""))	{
        				return $index;
	       			} 	  
	       		} else {
        			if ((!$row["note"]=="") and ($row["ispublic"]==$public) and ($row["objectkey"]==""))	{
        				return $index;
	       			} 	  
	       		}
        	}   
        	return 0;              
	} 
	
	protected function readControls($mc) {
		if (!$this->myModel[2] == "") {
	        	// private object notes
        		$val = $this->pane->named('myNotes')->value();
       	  		//echo "private object notes:".$val;

        		$row = $this->modelFor($public=FALSE, $object=TRUE);
        		$index = $this->indexFor($public=FALSE, $object=TRUE);
        		                 
			if ($row == 0) {
        			if (!$val == "") {          
        				// make a new one
	        			$row = array();
					$row["id"]=-1; // as a sign that this has to be inserted on OK
        				$row["userid"]=$this->myModel[1];
        				$row["ispublic"]=0;
	 		       		$row["objectkey"]=$this->myModel[2];
        				$row["windowclassname"]=$this->myModel[0];
        				$row["controlname"]=""; // not used yet
	        			$row["note"]=$val;
	        			array_push($this->myModel[3],$row);
        				error_log_adv("read private object notes: new row created:");//:".print_r($row,TRUE));
        	        	} else {
        	        		// no input, no record to update
        	        		error_log_adv("read private object notes: no input nothing to update");
        	        	}                
        		} else { // there is already a row for the data
       				$row["note"]=$val; // note: row will be deleted, if note is empty	
        			$this->myModel[3][$index] = $row;
        			error_log_adv("read private object notes: update row:".$index);
        		}       
	        	//error_log_adv("row:".print_r($row,TRUE));	        	                     
        	}
		
		// private window notes
		$val = $this->pane->named('myWindowNotes')->value();
		//echo "private window notes:".$val;
		
		$row = $this->modelFor($public=FALSE, $object=FALSE);
       		$index = $this->indexFor($public=FALSE, $object=FALSE);
        		 
		if ($row == 0) {
			if (!$val == "") {          			
				// make a new one
				$row = array();
				$row["id"]=-1; // as a sign that this has to be inserted on OK
				$row["userid"]=$this->myModel[1];
				$row["ispublic"]=0;
				$row["objectkey"]="";
				$row["windowclassname"]=$this->myModel[0];
				$row["controlname"]=""; // not used yet
				$row["note"]=$val;
				array_push($this->myModel[3],$row);
				error_log_adv("read private window notes: new row created:");
       	        	} else {
       	        		// no input, no record to update
       	        		error_log_adv("read private window notes: no input nothing to update");
        	        }                 
        	} else {// there is already a row for the data
        		$row["note"]=$val; // note: row will be deleted, if note is empty	
        		$this->myModel[3][$index] = $row;
       			error_log_adv("read private window notes: update row:".$index);
        	}       
        	//error_log_adv("row:".print_r($row,TRUE));	
        	//error_log_adv("readControls-myModel[3]:".print_r($this->myModel[3],TRUE));	
		$mc->model = $this->myModel;
		$mc->save();
	}
	
	protected function fillControls($mc) {
		
		//error_log_adv("fillControls-myModel[3]:".print_r($this->myModel[3],TRUE));	
		
		if (!$this->myModel[2] == "") {
			$this->pane->named('objecttitle')->setValue("Notes for object: ".$this->myModel[2]);
	        	// private object notes
			$this->pane->named('myNotes')->setValue(""); // reset previous value
			foreach($this->myModel[3] as $row) {
				if ((!$row["note"]=="") and ($row["ispublic"]==0) and (!$row["objectkey"]==""))	{
					//$note = $note."\r\n".$row["note"];
					$this->pane->named('myNotes')->setValue($row["note"]);
					break;		
				} 	
			}
			
			// public object notes
			$note ="";
			$this->pane->named('otherNotes')->setValue(""); // reset previous value
			foreach($this->myModel[3] as $row) {
				if ((!$row["note"]=="") and ($row["ispublic"]==1) and (!$row["objectkey"]==""))	{
					$note = $note."\r\n".$row["userid"].':'.$row["note"];
				} 	
			}			
			$this->pane->named('otherNotes')->setValue($note);		
		}
		
		// private window notes
		$this->pane->named('myWindowNotes')->setValue(""); // reset previous value
		foreach($this->myModel[3] as $row) {
			if ((!$row["note"]=="") and ($row["ispublic"]==0) and ($row["objectkey"]==""))	{
				//$note = $note."\r\n".$row["note"];
				$this->pane->named('myWindowNotes')->setValue($row["note"]);
				break;
			} 	
		}
		//echo print_r($this->myModel[3]);
		//		exit;				
				
				
		// public window notes
		$note ="";
		$this->pane->named('otherWindowNotes')->setValue(""); // reset previous value
		foreach($this->myModel[3] as $row) {
			if ((!$row["note"]=="") and ($row["ispublic"]==1) and ($row["objectkey"]==""))	{
				$note = $note."\r\n".$row["userid"].':'.$row["note"];
			} 	
		}
		$this->pane->named('otherWindowNotes')->setValue($note);		
	}

	//---callbacks--------------------------
	
	protected function eventHideOnotes() {
		// set my public object notes to private
		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
				
		//error_log_adv('myModel 3:'.print_r($this->myModel[3],TRUE));
		//print_r($this->myModel[3]);
		if ($this->modelFor($public=TRUE, $object=TRUE) == 0) return;

		// fetch private object notes
		$privateRow = $this->modelFor($public=FALSE, $object=TRUE);
		if ($privateRow == 0) { // no private row yet
			// convert public row to private
			
			$index = $this->indexFor($public=TRUE, $object=TRUE);
			$this->myModel[3][$index]["ispublic"]=0;
		} else { // private row exists
			// add text to end of private row
			$index = $this->indexFor($public=TRUE, $object=TRUE);
			$text = $this->myModel[3][$index]["note"];
			$private = $this->indexFor($public=FALSE, $object=TRUE);
			$this->myModel[3][$private]["note"] = $this->myModel[3][$private]["note"]."\r\n".$text;
			// delete old public row
			$this->myModel[3][$index]["note"] = "";
		}


 		$mc->model = $this->myModel;
		$mc->save();	
	}
	protected function eventHideWnotes() {
		// set my public window notes to private
		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
		//error_log_adv('myModel 3:'.print_r($this->myModel[3],TRUE));
		//print_r($this->myModel[3]);
		//$this->readControls($mc);
		//error_log_adv('myModel 3:'.print_r($this->myModel[3],TRUE));
		if ($this->modelFor($public=TRUE, $object=FALSE) == 0) return;

		// fetch private window notes
		$privateRow = $this->modelFor($public=FALSE, $object=FALSE);
		if ($privateRow == 0) { // no private row yet
			// convert public row to private
			
			$index = $this->indexFor($public=TRUE, $object=FALSE);
			$this->myModel[3][$index]["ispublic"]=0;
		} else { // private row exists
			// add text to end of private row
			$index = $this->indexFor($public=TRUE, $object=FALSE);
			$text = $this->myModel[3][$index]["note"];
			$private = $this->indexFor($public=FALSE, $object=FALSE);
			$this->myModel[3][$private]["note"] = $this->myModel[3][$private]["note"]."\r\n".$text;
			// delete old public row
			$this->myModel[3][$index]["note"] = "";
		}

 		$mc->model = $this->myModel;
		$mc->save();	
	}
	protected function eventPublishOnotes() {
		// set my private object notes to public
		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
		
		$row = $this->modelFor($public=FALSE, $object=TRUE);
		if (!$row == 0) {
		
			$row["id"]=-1; // as a sign that this has to be inserted on OK
			$row["ispublic"] = 1;
			array_push($this->myModel[3],$row);

			$index = $this->indexFor($public=FALSE, $object=TRUE);
			$this->myModel[3][$index]["note"] = ""; // to be deleted

			//error_log_adv('myModel 3 after publish:'.print_r($this->myModel[3],TRUE));
		
			$mc->model = $this->myModel;
			$mc->save();
		}
	}
	protected function eventPublishWnotes() {
		// set my private window notes to public
		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
		$row = $this->modelFor($public=FALSE, $object=FALSE);
		if (!$row == 0) {
			$row["id"]=-1; // as a sign that this has to be inserted on OK
			$row["ispublic"] = 1;
			array_push($this->myModel[3],$row);

			$index = $this->indexFor($public=FALSE, $object=FALSE);
			$this->myModel[3][$index]["note"] = ""; // to be deleted

			error_log_adv('myModel 3 after publish:'.print_r($this->myModel[3],TRUE));
		
			$mc->model = $this->myModel;
			$mc->save();
		}	
	}
	

	protected function eventOK() {
		global $db;
		global $errorStack;

 		$mc = &windowContext($this->myContextID,0);
		//$this->readControls($mc);
		// Begin a db transaction
		$db->beginTransaction();		
		// read row again
		$res = $db->execSQL($this->createSELECT($mc));
		if (!$db->OK()) {
			$errorStack->pushMsg("GGFControlNotesDialog: Cannot re-read notes records.");
			// not necessary to display error here, done in open
			$db->cancelTransaction();
			return;
		} else {
			$arr = array();
			while($row = $db->fetchRow($res)) {
				array_push($arr, $row);
			}
			
			// compare with rows in model
			$oldrows = $this->myModel["_preimage"];
			
			if (count(array_diff_assoc($oldrows, $arr))>0) {
				// double update happened
				$errorStack->pushUsrMsg(1,"GGFControlNotesDialog: A parallel update of the record happened. Please Retry");
				// not necessary to display error here, done in open
				$db->cancelTransaction();
				return;
			} else {
				// nothing changed in db in meantime
				foreach ($this->myModel[3] as $row) {
					if ($row["note"] == "" ) {
						$sql = $this->createDELETE($mc,$row);
					} else {
						if ($row["id"] < 0 ) {
							$sql = $this->createINSERT($mc,$row);
						} else {
							$sql = $this->createUPDATE($mc,$row);
						}
					}
					// write db
					$db->execSQL($sql); 
					if (!$db->OK()) {
						$errorStack->pushUsrMsg(1,"Cannot update a notes-record");	
						$db->cancelTransaction();
						break;
					} else {
					}
				}
				//end foreach
				$db->endTransaction();
				if ($db->OK()) {
					$this->ok = TRUE;
					$this->eventClose();	
				}
			}
		}
	}
	
	protected function eventClose() {
   		// this is called when the window is to be closed
   		// go back in dialog stack or to bye window

		global $errorStack;
		global $goodbyefile;
		
		// check, if there are errors in the stack left that are yet to display
		if (!$errorStack->isEmpty()) {
			return $this->eventDisplayError();
		}
		
   		$myContext = &dialogContextWithFrom($this->myContextID,0,0,0);
   		$myContext->invalidate();
		
   		header('Location: '.$goodbyefile);
		exit;

	}
	
	//---open---------------
	/*
	CREATE TABLE GGFNote
	(	id		integer AUTO_INCREMENT,
	last_change 	TIMESTAMP,
	userid  	VARCHAR(16) NOT NULL,
	ispublic        BOOL,
	objectkey       VARCHAR(64),
	windowclassname VARCHAR(64) NOT NULL,
	controlname	VARCHAR(64),
	note		TEXT,
	PRIMARY KEY (id)
	*/
   	protected function createSELECT($mc) {
   		// the select statement to read the row
   		global $db;
   		
   		return "SELECT * ".
   		/*
   		id,last_change,userid,".
   		"ispublic,controlname,note ".*/
   		" FROM GGFNote WHERE ".
   		" (windowclassname='".$mc->model[0]."' AND objectkey='".$mc->model[2]."' AND ispublic = 1) OR ".
   		" (windowclassname='".$mc->model[0]."' AND objectkey='' AND ispublic = 1) OR ".
   		" (windowclassname='".$mc->model[0]."' AND objectkey='".$mc->model[2]."' AND ispublic = 0 AND userid='".$db->escape_string($_SESSION["userid"])."') OR ".
   		" (windowclassname='".$mc->model[0]."' AND objectkey='' AND ispublic = 0 AND userid='".$db->escape_string($_SESSION["userid"])."') ".
   		"ORDER BY last_change DESC";
	}
	protected function createUPDATE($mc, $row) {
		//create the update statement , with data from controls
		//may check input validity here
		global $db;
		
		$sql = "UPDATE GGFNote SET ".
			" userid='".  $db->escape_string($row["userid"])."',".
			" ispublic=". $db->escape_string($row["ispublic"]).",".
			" objectkey='". $db->escape_string($row["objectkey"])."',".
			" windowclassname='". $db->escape_string($row["windowclassname"])."',".
			" controlname='". $db->escape_string($row["controlname"])."',".
			" note='". $db->escape_string($row["note"])."'".				
			" WHERE id=".$db->escape_string($row["id"]);
		return $sql;
	}

	protected function createINSERT($mc, $row) {
		global $db;

		$sql = "INSERT INTO GGFNote VALUES ".
			" (NULL, NULL, ".
			" '". $db->escape_string($row["userid"])."',".
			"  ". $db->escape_string($row["ispublic"]).",".
			" '". $db->escape_string($row["objectkey"])."',".
			" '". $db->escape_string($row["windowclassname"])."',".
			" '". $db->escape_string($row["controlname"])."',".
			" '". $db->escape_string($row["note"])."')";
		return $sql;
	}
	protected function createDELETE($mc, $row) {
		global $db;
		
		$sql = "DELETE FROM GGFNote WHERE id=".$db->escape_string($row["id"]);
		return $sql;
	}


	protected function openHeadTitle() {
		global $appname;
		echo "<title>".$appname.": Notes </title>";
	}
		
	protected function openFormContents() {
		echo $this->pane->render();
	}
	
}
?>