<?PHP
	/**
	 * shows errors from errorstack
	 * For GGF internal use.
	 * 
	 * @package GGF
	 * @version 4.0
	 * @since 1.0
	 * @author Gerald Zincke, Austria
	 * @copyright 2011 Gerald Zincke
	 * @license http://www.reinhtml.eu/ggf/license.html#top
	 */
	class GGFControlErrorDialog extends GGFControlDialog {
		
	protected $isFilled;
	
	function __construct($contextID) {
    	parent::__construct($contextID);
    	$this->ETypeName = 'user';
    	$this->extraAttributesToUpdate = array();
    	$this->isFilled = FALSE;
   	}
	function __destruct() {
    	parent::__destruct();
   	}

	protected  function adminIsLoggedOn() {
		// use this to protect callbacks
		if (!isset($_SESSION["userid"])) {
			return FALSE;
		}
		$user = $_SESSION["userid"];
		if (strcmp($user,"admin")==0) return TRUE;
		return FALSE; 
	}
	
	protected function initModel($mc) {
		global $errorStack;
		$this->myModel = $mc->model;

		if (!isset($this->myModel[1])) {
			$em = $errorStack->popAll();
			$this->myModel = array(0,$em);
			$mc->model = $this->myModel;
			$mc->save();
		}
		
	}
	
	protected function fillControls($mc) {
		global $appname;
		global $errorStack;
		
		
		// note: fill-controls is called twice by the framework	
		if ($this->isFilled) {
			return ;
		} else {
			$this->isFilled = TRUE;
			$this->setWindowTitle("Error in ".$appname);
			$msgPane = $this->pane->named("detailed Messages");
			
			$em = $this->myModel[1];
			$msgs = array();
			
			foreach ($em as $txt) {
				if (!($this->adminIsLoggedOn())) {
					if (strcmp(substr($txt,0,3),'usr')==0 ) {
						$msgs[] = substr($txt,3);
					};
				} else {
					$msgs[] = $txt;
				}
			}
			if (count($msgs)==0) {
				$msgs[] = "An internal error occurred. Contact the system administrator.";
			}
		
			$i = 1;
			if (count($msgs)==1) {
				$this->pane->named("msg")->setValue(/*print_r($msgs, TRUE)*/$msgs[0]);   			
				$s = new GGFStaticfield("msg-".$i,"Submessage",""); 
				$s->setValue("none");
				$msgPane->newRow($s);
	   		} else {
		   		foreach ($msgs as $msg) {
		   			if ($i==count($msgs)) {
						$this->pane->named("msg")->setValue($msg);   			
		   			} else {
						$s = new GGFStaticfield("msg-".$i,"Submessage",""); 
						$s->setValue($msg);
						//print_r($msgs[$i]);
						$msgPane->newRow($s);
		   			}
		   			$i++;
		   		}
	   		}
		}			
   		
   	}
   	
	public function dataPlausible() {
		return TRUE;
	}
	
   	/**
   	** RD generated function initWindow
   	* create the layout definition of the window
   	*/
   	protected function initWindow($mc) {
		
		//*H1--generated code, do not touch. Use RD to update ---
		$this->windowTitle='Error in HDD Application';
		$cont0 = new GGFControlPane("_main","",""); $cont0->initializeProperties(array("name" => "_main","myContainer" => "","myWindow" => "","controls" => "","disabled" => "","inTable" => "","tabindex" => "","bodyExtraHTML" => "","frameID" => "","paneType" => "","isFrameset" => "","style" => "","Foreground" => "","Background" => ""));
		$cont0->setWindow($this);
		$this->pane = $cont0;
		   $cont1 = new GGFDialogFormPane("_mainform","",""); $cont1->initializeProperties(array("html" => "","demohtml" => "","demohtml2" => "","html2" => "","name" => "_mainform","myContainer" => "","myWindow" => "","controls" => "","disabled" => "","inTable" => "","tabindex" => "","bodyExtraHTML" => "","frameID" => "","paneType" => "","isFrameset" => "","style" => "","Foreground" => "","Background" => ""));
		   $cont0->add($cont1);
		      $cont2 = new GGFNewLinePane("tit","",""); $cont2->initializeProperties(array("name" => "tit","myContainer" => "","myWindow" => "","controls" => "","disabled" => "","inTable" => "","tabindex" => "","bodyExtraHTML" => "","frameID" => "","paneType" => "","isFrameset" => "","style" => "text-align:center;","Foreground" => "","Background" => ""));
		      $cont1->add($cont2);
		         $cont3 = new GGFStaticfield("s1","An Error has occurred",""); $cont3->initializeProperties(array("html" => "","name" => "s1","value" => "An Error has occurred","size" => "","extraHTML" => "text-align:center;","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "#000000","Background" => "","fontFamily" => "default","fontSize" => "","fontStyle" =>  array(bold => "1", italic => "", underline => "1"), ));
		         $cont2->add($cont3);
		      $cont4 = new GGFEndPane("end:tit","",""); $cont4->initializeProperties(array("html" => "","name" => "end:tit","value" => "","size" => "","extraHTML" => "","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		      $cont2->add($cont4);
		      $cont1->newP();
		      $cont6 = new GGFStaticfield("msg","Hauptmessage",""); $cont6->initializeProperties(array("html" => "","name" => "msg","value" => "Hauptmessage","size" => "","extraHTML" => " ","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "#B40431","Background" => "","fontFamily" => "default","fontSize" => "","fontStyle" =>  array(bold => "1", italic => "", underline => ""), ));
		      $cont1->newRow($cont6);
		      $cont1->newP();
		      $cont8 = new GGFFieldsetPane("detailed Messages","",""); $cont8->initializeProperties(array("name" => "detailed Messages","myContainer" => "","myWindow" => "","controls" => "","disabled" => "","inTable" => "","tabindex" => "","bodyExtraHTML" => "","frameID" => "","paneType" => "","isFrameset" => "","style" => "","Foreground" => "","Background" => ""));
		      $cont1->add($cont8);
		      $cont9 = new GGFEndPane("end:detailed Messages","",""); $cont9->initializeProperties(array("html" => "","name" => "end:detailed Messages","value" => "","size" => "","extraHTML" => "","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		      $cont8->add($cont9);
		      $cont1->newP();
		      $cont11 = new GGFControlPane("_buttonarea","",""); $cont11->initializeProperties(array("name" => "_buttonarea","myContainer" => "","myWindow" => "","controls" => "","disabled" => "","inTable" => "","tabindex" => "","bodyExtraHTML" => "","frameID" => "","paneType" => "","isFrameset" => "","style" => "","Foreground" => "","Background" => ""));
		      $cont1->newTable($cont11);
		         $cont12 = new GGFPushbutton("_OK","OK","60"); $cont12->initializeProperties(array("callback" => "eventOK","validator" => "dataPlausible","html" => "","name" => "_OK","value" => "OK","size" => "60","extraHTML" => "width:80px; overflow:hidden;","tiptext" => "continue","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		         $cont11->add($cont12);
		      $cont13 = new GGFEndPane("end:_buttonarea","",""); $cont13->initializeProperties(array("html" => "","name" => "end:_buttonarea","value" => "","size" => "","extraHTML" => "","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		      $cont11->add($cont13);
		   $cont14 = new GGFEndPane("end:_mainform","",""); $cont14->initializeProperties(array("html" => "","name" => "end:_mainform","value" => "","size" => "","extraHTML" => "","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		   $cont1->add($cont14);
		$cont15 = new GGFEndPane("end:_main","",""); $cont15->initializeProperties(array("html" => "","name" => "end:_main","value" => "","size" => "","extraHTML" => "","tiptext" => "","myContainer" => "","myWindow" => "","tabindex" => "","isDisabled" => "","readonly" => "","mandatory" => "","Foreground" => "","Background" => "","fontFamily" => "","fontSize" => "","fontStyle" => ""));
		$cont0->add($cont15);
		//****HDD generated code, do not touch**********
		//*HDD*613a343a7b693a303b623a313b693a313b613a31363a7b693a303b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31343a7b733a343a226e616d65223b733a353a225f6d61696e223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22636f6e74726f6c73223b733a303a22223b733a383a2264697361626c6564223b733a303a22223b733a373a22696e5461626c65223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31333a22626f6479457874726148544d4c223b733a303a22223b733a373a226672616d654944223b733a303a22223b733a383a2270616e6554797065223b733a303a22223b733a31303a2269734672616d65736574223b733a303a22223b733a353a227374796c65223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a22474746436f6e74726f6c50616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a303b7d693a313b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31383a7b733a343a2268746d6c223b733a303a22223b733a383a2264656d6f68746d6c223b733a303a22223b733a393a2264656d6f68746d6c32223b733a303a22223b733a353a2268746d6c32223b733a303a22223b733a343a226e616d65223b733a393a225f6d61696e666f726d223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22636f6e74726f6c73223b733a303a22223b733a383a2264697361626c6564223b733a303a22223b733a373a22696e5461626c65223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31333a22626f6479457874726148544d4c223b733a303a22223b733a373a226672616d654944223b733a303a22223b733a383a2270616e6554797065223b733a303a22223b733a31303a2269734672616d65736574223b733a303a22223b733a353a227374796c65223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31373a224747464469616c6f67466f726d50616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a303b7d693a323b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31343a7b733a343a226e616d65223b733a333a22746974223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22636f6e74726f6c73223b733a303a22223b733a383a2264697361626c6564223b733a303a22223b733a373a22696e5461626c65223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31333a22626f6479457874726148544d4c223b733a303a22223b733a373a226672616d654944223b733a303a22223b733a383a2270616e6554797065223b733a303a22223b733a31303a2269734672616d65736574223b733a303a22223b733a353a227374796c65223b733a31383a22746578742d616c69676e3a63656e7465723b223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a224747464e65774c696e6550616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a333b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a323a227331223b733a353a2276616c7565223b733a32313a22416e204572726f7220686173206f63637572726564223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a31383a22746578742d616c69676e3a63656e7465723b223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b623a303b733a383a22726561646f6e6c79223b623a303b733a393a226d616e6461746f7279223b623a303b733a31303a22466f726567726f756e64223b733a373a2223303030303030223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a373a2264656661756c74223b733a383a22666f6e7453697a65223b4e3b733a393a22666f6e745374796c65223b613a333a7b733a343a22626f6c64223b623a313b733a363a226974616c6963223b623a303b733a393a22756e6465726c696e65223b623a313b7d7d733a31323a22002a00636c6173734e616d65223b733a31343a224747465374617469636669656c64223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a323b7d693a343b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a373a22656e643a746974223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31303a22474746456e6450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a323b7d693a353b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a353a225f4e657750223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a224747465374617469634669656c64223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a363b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a333a226d7367223b733a353a2276616c7565223b733a31323a2248617570746d657373616765223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a313a2220223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b623a303b733a383a22726561646f6e6c79223b623a303b733a393a226d616e6461746f7279223b623a303b733a31303a22466f726567726f756e64223b733a373a2223423430343331223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a373a2264656661756c74223b733a383a22666f6e7453697a65223b4e3b733a393a22666f6e745374796c65223b613a333a7b733a343a22626f6c64223b623a313b733a363a226974616c6963223b623a303b733a393a22756e6465726c696e65223b623a303b7d7d733a31323a22002a00636c6173734e616d65223b733a31343a224747465374617469636669656c64223b733a31343a22002a0061646446756e6374696f6e223b733a363a226e6577526f77223b733a373a22002a0070616e65223b693a313b7d693a373b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a353a225f4e657750223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a224747465374617469634669656c64223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a383b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31343a7b733a343a226e616d65223b733a31373a2264657461696c6564204d65737361676573223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22636f6e74726f6c73223b733a303a22223b733a383a2264697361626c6564223b733a303a22223b733a373a22696e5461626c65223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31333a22626f6479457874726148544d4c223b733a303a22223b733a373a226672616d654944223b733a303a22223b733a383a2270616e6554797065223b733a303a22223b733a31303a2269734672616d65736574223b733a303a22223b733a353a227374796c65223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31353a224747464669656c6473657450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a393b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a32313a22656e643a64657461696c6564204d65737361676573223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31303a22474746456e6450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a383b7d693a31303b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a353a225f4e657750223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a224747465374617469634669656c64223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a31313b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31343a7b733a343a226e616d65223b733a31313a225f627574746f6e61726561223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22636f6e74726f6c73223b733a303a22223b733a383a2264697361626c6564223b733a303a22223b733a373a22696e5461626c65223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31333a22626f6479457874726148544d4c223b733a303a22223b733a373a226672616d654944223b733a303a22223b733a383a2270616e6554797065223b733a303a22223b733a31303a2269734672616d65736574223b733a303a22223b733a353a227374796c65223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31343a22474746436f6e74726f6c50616e65223b733a31343a22002a0061646446756e6374696f6e223b733a383a226e65775461626c65223b733a373a22002a0070616e65223b693a313b7d693a31323b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31393a7b733a383a2263616c6c6261636b223b733a373a226576656e744f4b223b733a393a2276616c696461746f72223b733a31333a2264617461506c61757369626c65223b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a333a225f4f4b223b733a353a2276616c7565223b733a323a224f4b223b733a343a2273697a65223b733a323a223630223b733a393a22657874726148544d4c223b733a32383a2277696474683a383070783b206f766572666c6f773a68696464656e3b223b733a373a2274697074657874223b733a383a22636f6e74696e7565223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b623a303b733a383a22726561646f6e6c79223b623a303b733a393a226d616e6461746f7279223b623a303b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31333a2247474650757368627574746f6e223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a31313b7d693a31333b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a31353a22656e643a5f627574746f6e61726561223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31303a22474746456e6450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a31313b7d693a31343b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a31333a22656e643a5f6d61696e666f726d223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31303a22474746456e6450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a313b7d693a31353b4f3a32303a22484444436f6e74726f6c44657363726970746f72223a343a7b733a31333a22002a0070726f70657274696573223b613a31373a7b733a343a2268746d6c223b733a303a22223b733a343a226e616d65223b733a393a22656e643a5f6d61696e223b733a353a2276616c7565223b733a303a22223b733a343a2273697a65223b733a303a22223b733a393a22657874726148544d4c223b733a303a22223b733a373a2274697074657874223b733a303a22223b733a31313a226d79436f6e7461696e6572223b733a303a22223b733a383a226d7957696e646f77223b733a303a22223b733a383a22746162696e646578223b733a303a22223b733a31303a22697344697361626c6564223b733a303a22223b733a383a22726561646f6e6c79223b733a303a22223b733a393a226d616e6461746f7279223b733a303a22223b733a31303a22466f726567726f756e64223b733a303a22223b733a31303a224261636b67726f756e64223b733a303a22223b733a31303a22666f6e7446616d696c79223b733a303a22223b733a383a22666f6e7453697a65223b733a303a22223b733a393a22666f6e745374796c65223b733a303a22223b7d733a31323a22002a00636c6173734e616d65223b733a31303a22474746456e6450616e65223b733a31343a22002a0061646446756e6374696f6e223b733a333a22616464223b733a373a22002a0070616e65223b693a303b7d7d693a323b733a32343a224572726f7220696e20484444204170706c69636174696f6e223b693a333b733a303a22223b7d*HDD*//
		//*H2--end of generated code, do not touch code above. Use RD to update ---
	} // end initWindow		
		//*H3--RD-generated event handlers below. do not remove this line.				
	/**
	** RD generated function
	* event handler for control Pushbutton(_OK, OK, 60)  
	* 
   	* @todo replace HDD-generated template-code by desired functionality
    * 
   	*/
	protected function eventOK() {
	 	parent::eventOK();
	}
	
	/**
	** RD generated function
   	* Evaluating results from dialogs opened by eventhandler for control Pushbutton(_OK, OK, 60)  
	* 
   	* @todo replace HDD-generated template code by desired functionality
   	* @param int ID of the context of the dialog
    * 
   	*/
	protected function eventOKContinue($subContextID) {
	 	// ---- begin template code ----
		$subContext = &windowContext($subContextID, 0);
		if ($subContext->result) {	// Yes clicked
			// insert code here
		} else {					// no clicked
			// insert code her
		}
		// ---- end template code ----
	}
					
					
				
	
} //end HDD generated class GGFControlErrorDialog
?>